/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import org.hibernate.MappingException;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.PropertyData;

public class PropertyInferredData
implements PropertyData {
    private final AccessType defaultAccess;
    private final XProperty property;
    private final ReflectionManager reflectionManager;
    private final XClass declaringClass;

    public PropertyInferredData(XClass declaringClass, XProperty property, String propertyAccessor, ReflectionManager reflectionManager) {
        this.declaringClass = declaringClass;
        this.property = property;
        this.defaultAccess = AccessType.getAccessStrategy(propertyAccessor);
        this.reflectionManager = reflectionManager;
    }

    public String toString() {
        return String.format("PropertyInferredData{property=%s, declaringClass=%s}", this.property, this.declaringClass);
    }

    @Override
    public AccessType getDefaultAccess() throws MappingException {
        AccessType accessType = this.defaultAccess;
        AccessType jpaAccessType = AccessType.DEFAULT;
        Access access = this.property.getAnnotation(Access.class);
        if (access != null) {
            jpaAccessType = AccessType.getAccessStrategy(access.value());
        }
        if (jpaAccessType != AccessType.DEFAULT) {
            accessType = jpaAccessType;
        }
        return accessType;
    }

    @Override
    public String getPropertyName() throws MappingException {
        return this.property.getName();
    }

    @Override
    public XClass getPropertyClass() throws MappingException {
        if (this.property.isAnnotationPresent(Target.class)) {
            return this.reflectionManager.toXClass(this.property.getAnnotation(Target.class).value());
        }
        return this.property.getType();
    }

    @Override
    public XClass getClassOrElement() throws MappingException {
        if (this.property.isAnnotationPresent(Target.class)) {
            return this.reflectionManager.toXClass(this.property.getAnnotation(Target.class).value());
        }
        return this.property.getClassOrElementClass();
    }

    @Override
    public String getClassOrElementName() throws MappingException {
        return this.getClassOrElement().getName();
    }

    @Override
    public String getTypeName() throws MappingException {
        return this.getPropertyClass().getName();
    }

    @Override
    public XProperty getProperty() {
        return this.property;
    }

    @Override
    public XClass getDeclaringClass() {
        return this.declaringClass;
    }
}

