/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal;

import java.util.Map;
import org.hibernate.Internal;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public final class BytecodeProviderInitiator
implements StandardServiceInitiator<BytecodeProvider> {
    public static final String BYTECODE_PROVIDER_NAME_BYTEBUDDY = "bytebuddy";
    public static final String BYTECODE_PROVIDER_NAME_NONE = "none";
    public static final String BYTECODE_PROVIDER_NAME_DEFAULT = "bytebuddy";
    public static final StandardServiceInitiator<BytecodeProvider> INSTANCE = new BytecodeProviderInitiator();

    @Override
    public BytecodeProvider initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        String provider = ConfigurationHelper.getString("hibernate.bytecode.provider", configurationValues, "bytebuddy");
        return BytecodeProviderInitiator.buildBytecodeProvider(provider);
    }

    @Override
    public Class<BytecodeProvider> getServiceInitiated() {
        return BytecodeProvider.class;
    }

    @Internal
    public static BytecodeProvider buildDefaultBytecodeProvider() {
        return BytecodeProviderInitiator.buildBytecodeProvider("bytebuddy");
    }

    @Internal
    public static BytecodeProvider buildBytecodeProvider(String providerName) {
        CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, BytecodeProviderInitiator.class.getName());
        LOG.bytecodeProvider(providerName);
        if (BYTECODE_PROVIDER_NAME_NONE.equals(providerName)) {
            return new org.hibernate.bytecode.internal.none.BytecodeProviderImpl();
        }
        if ("bytebuddy".equals(providerName)) {
            return new BytecodeProviderImpl();
        }
        LOG.unknownBytecodeProvider(providerName, "bytebuddy");
        return new BytecodeProviderImpl();
    }
}

