/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.io.OutputStream;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.hibernate.Internal;
import org.hibernate.dialect.StructHelper;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.descriptor.java.OffsetDateTimeJavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;

@Internal
public class JsonHelper {
    public static String toString(EmbeddableMappingType embeddableMappingType, Object value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        JsonHelper.toString(embeddableMappingType, value, options, new JsonAppender(sb));
        return sb.toString();
    }

    private static void toString(EmbeddableMappingType embeddableMappingType, Object value, WrapperOptions options, JsonAppender appender) {
        Object[] values = embeddableMappingType.getValues(value);
        JsonHelper.toString(embeddableMappingType, options, appender, values, '{');
        appender.append('}');
    }

    private static void toString(EmbeddableMappingType embeddableMappingType, WrapperOptions options, JsonAppender appender, Object[] values, char separator) {
        for (int i = 0; i < values.length; ++i) {
            AttributeMapping attributeMapping = embeddableMappingType.getAttributeMapping(i);
            if (attributeMapping instanceof SelectableMapping) {
                String name = ((SelectableMapping)((Object)attributeMapping)).getSelectableName();
                appender.append(separator);
                appender.append('\"');
                appender.append(name);
                appender.append("\":");
                JsonHelper.toString(attributeMapping.getMappedType(), values[i], options, appender);
            } else if (attributeMapping instanceof EmbeddedAttributeMapping) {
                EmbeddableMappingType mappingType = (EmbeddableMappingType)attributeMapping.getMappedType();
                SelectableMapping aggregateMapping = mappingType.getAggregateMapping();
                if (aggregateMapping == null) {
                    if (values[i] == null) continue;
                    JsonHelper.toString(mappingType, options, appender, mappingType.getValues(values[i]), separator);
                } else {
                    String name = aggregateMapping.getSelectableName();
                    appender.append(separator);
                    appender.append('\"');
                    appender.append(name);
                    appender.append("\":");
                    JsonHelper.toString(mappingType, values[i], options, appender);
                }
            } else {
                throw new UnsupportedOperationException("Support for attribute mapping type not yet implemented: " + attributeMapping.getClass().getName());
            }
            separator = (char)44;
        }
    }

    private static void toString(MappingType mappedType, Object value, WrapperOptions options, JsonAppender appender) {
        if (value == null) {
            appender.append("null");
        } else if (mappedType instanceof EmbeddableMappingType) {
            JsonHelper.toString((EmbeddableMappingType)mappedType, value, options, appender);
        } else if (mappedType instanceof BasicType) {
            BasicType basicType = (BasicType)mappedType;
            JavaType<?> javaType = basicType.getJdbcJavaType();
            value = basicType.convertToRelationalValue(value);
            switch (basicType.getJdbcType().getDefaultSqlTypeCode()) {
                case -6: 
                case 4: 
                case 5: {
                    if (value instanceof Boolean) {
                        appender.append((Boolean)value != false ? (char)'1' : '0');
                        break;
                    }
                    if (value instanceof Enum) {
                        appender.appendSql(((Enum)value).ordinal());
                        break;
                    }
                }
                case -7: 
                case -5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    javaType.appendEncodedString(appender, value);
                    break;
                }
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    if (value instanceof Boolean) {
                        appender.append('\"');
                        appender.append((Boolean)value != false ? (char)'Y' : 'N');
                        appender.append('\"');
                        break;
                    }
                }
                case -16: 
                case -1: 
                case 4001: 
                case 4002: 
                case 6000: 
                case 6001: {
                    appender.append('\"');
                    appender.startEscaping();
                    javaType.appendEncodedString(appender, value);
                    appender.endEscaping();
                    appender.append('\"');
                    break;
                }
                case 91: {
                    appender.append('\"');
                    JdbcDateJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, javaType.unwrap(value, Date.class, options));
                    appender.append('\"');
                    break;
                }
                case 92: 
                case 2013: 
                case 3007: {
                    appender.append('\"');
                    JdbcTimeJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, javaType.unwrap(value, Time.class, options));
                    appender.append('\"');
                    break;
                }
                case 93: {
                    appender.append('\"');
                    JdbcTimestampJavaType.INSTANCE.appendEncodedString((SqlAppender)appender, javaType.unwrap(value, Timestamp.class, options));
                    appender.append('\"');
                    break;
                }
                case 2014: 
                case 3003: {
                    appender.append('\"');
                    DateTimeFormatter.ISO_OFFSET_DATE_TIME.formatTo(javaType.unwrap(value, OffsetDateTime.class, options), appender);
                    appender.append('\"');
                    break;
                }
                case 2: 
                case 3: 
                case 3000: {
                    appender.append('\"');
                    javaType.appendEncodedString(appender, value);
                    appender.append('\"');
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 4003: {
                    appender.append('\"');
                    appender.write(javaType.unwrap(value, byte[].class, options));
                    appender.append('\"');
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported JdbcType nested in JSON: " + basicType.getJdbcType());
                }
            }
        } else {
            throw new UnsupportedOperationException("Support for mapping type not yet implemented: " + mappedType.getClass().getName());
        }
    }

    public static <X> X fromString(EmbeddableMappingType embeddableMappingType, String string, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        if (string == null) {
            return null;
        }
        Object[] values = new Object[embeddableMappingType.getJdbcValueCount()];
        int end = JsonHelper.fromString(embeddableMappingType, string, 0, string.length(), values, returnEmbeddable, options);
        assert (string.substring(end).isBlank());
        if (returnEmbeddable) {
            Object[] attributeValues = StructHelper.getAttributeValues(embeddableMappingType, values, options);
            return (X)embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> attributeValues, options.getSessionFactory());
        }
        return (X)values;
    }

    private static int fromString(EmbeddableMappingType embeddableMappingType, String string, int begin, int end, Object[] values, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        boolean hasEscape = false;
        assert (string.charAt(begin) == '{');
        int start = begin + 1;
        State s = State.KEY_START;
        int selectableIndex = -1;
        block35: for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    assert (s == State.KEY_QUOTE || s == State.VALUE_QUOTE);
                    hasEscape = true;
                    ++i;
                    continue block35;
                }
                case '\"': {
                    switch (s) {
                        case KEY_START: {
                            s = State.KEY_QUOTE;
                            selectableIndex = -1;
                            start = i + 1;
                            hasEscape = false;
                            continue block35;
                        }
                        case KEY_QUOTE: {
                            s = State.KEY_END;
                            selectableIndex = JsonHelper.getSelectableMapping(embeddableMappingType, string, start, i, hasEscape);
                            start = -1;
                            hasEscape = false;
                            continue block35;
                        }
                        case VALUE_START: {
                            s = State.VALUE_QUOTE;
                            start = i + 1;
                            hasEscape = false;
                            continue block35;
                        }
                        case VALUE_QUOTE: {
                            s = State.VALUE_END;
                            values[selectableIndex] = JsonHelper.fromString(embeddableMappingType.getJdbcValueSelectable(selectableIndex).getJdbcMapping(), string, start, i, hasEscape, returnEmbeddable, options);
                            selectableIndex = -1;
                            start = -1;
                            hasEscape = false;
                            continue block35;
                        }
                    }
                    throw JsonHelper.syntaxError(string, s, i);
                }
                case ':': {
                    switch (s) {
                        case KEY_QUOTE: 
                        case VALUE_QUOTE: {
                            continue block35;
                        }
                        case KEY_END: {
                            s = State.VALUE_START;
                            continue block35;
                        }
                    }
                    throw JsonHelper.syntaxError(string, s, i);
                }
                case ',': {
                    switch (s) {
                        case KEY_QUOTE: 
                        case VALUE_QUOTE: {
                            continue block35;
                        }
                        case VALUE_END: {
                            s = State.KEY_START;
                            continue block35;
                        }
                    }
                    throw JsonHelper.syntaxError(string, s, i);
                }
                case '{': {
                    switch (s) {
                        case KEY_QUOTE: 
                        case VALUE_QUOTE: {
                            continue block35;
                        }
                        case VALUE_START: {
                            SelectableMapping selectable = embeddableMappingType.getJdbcValueSelectable(selectableIndex);
                            if (!(selectable.getJdbcMapping().getJdbcType() instanceof AggregateJdbcType)) {
                                throw new IllegalArgumentException(String.format("JSON starts sub-object for a non-aggregate type at index %d. Selectable [%s] is of type [%s]", i, selectable.getSelectableName(), selectable.getJdbcMapping().getJdbcType().getClass().getName()));
                            }
                            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)selectable.getJdbcMapping().getJdbcType();
                            EmbeddableMappingType subMappingType = aggregateJdbcType.getEmbeddableMappingType();
                            assert (aggregateJdbcType.getJdbcTypeCode() == 3001 || aggregateJdbcType.getDefaultSqlTypeCode() == 3001);
                            Object[] subValues = new Object[subMappingType.getJdbcValueCount()];
                            i = JsonHelper.fromString(subMappingType, string, i, end, subValues, returnEmbeddable, options) - 1;
                            assert (string.charAt(i) == '}');
                            if (returnEmbeddable) {
                                Object[] attributeValues = StructHelper.getAttributeValues(subMappingType, subValues, options);
                                values[selectableIndex] = embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> attributeValues, options.getSessionFactory());
                            } else {
                                values[selectableIndex] = subValues;
                            }
                            s = State.VALUE_END;
                            selectableIndex = -1;
                            continue block35;
                        }
                    }
                    throw JsonHelper.syntaxError(string, s, i);
                }
                case '}': {
                    switch (s) {
                        case KEY_QUOTE: 
                        case VALUE_QUOTE: {
                            continue block35;
                        }
                        case VALUE_END: {
                            return i + 1;
                        }
                    }
                    throw JsonHelper.syntaxError(string, s, i);
                }
                default: {
                    switch (s) {
                        case KEY_QUOTE: 
                        case VALUE_QUOTE: {
                            continue block35;
                        }
                        case VALUE_START: {
                            if (Character.isWhitespace(c)) continue block35;
                            int endIdx = JsonHelper.consumeLiteral(string, i, values, embeddableMappingType, selectableIndex, returnEmbeddable, options);
                            if (endIdx != -1) {
                                i = endIdx;
                                s = State.VALUE_END;
                                selectableIndex = -1;
                                start = -1;
                                continue block35;
                            }
                            throw JsonHelper.syntaxError(string, s, i);
                        }
                        case KEY_START: 
                        case KEY_END: 
                        case VALUE_END: {
                            if (Character.isWhitespace(c)) continue block35;
                        }
                        default: {
                            throw JsonHelper.syntaxError(string, s, i);
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("JSON not properly formed: " + string.subSequence(start, end));
    }

    private static int consumeLiteral(String string, int start, Object[] values, EmbeddableMappingType embeddableMappingType, int selectableIndex, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        char c = string.charAt(start);
        switch (c) {
            case 'n': {
                values[selectableIndex] = null;
                return JsonHelper.consume(string, start, "null");
            }
            case 'f': {
                values[selectableIndex] = false;
                return JsonHelper.consume(string, start, "false");
            }
            case 't': {
                values[selectableIndex] = true;
                return JsonHelper.consume(string, start, "true");
            }
            case '0': {
                switch (string.charAt(start + 1)) {
                    case '.': {
                        return JsonHelper.consumeFractional(string, start, start + 1, values, embeddableMappingType, selectableIndex, returnEmbeddable, options);
                    }
                    case 'E': 
                    case 'e': {
                        return JsonHelper.consumeExponential(string, start, start + 1, values, embeddableMappingType, selectableIndex, returnEmbeddable, options);
                    }
                }
                values[selectableIndex] = JsonHelper.fromString(embeddableMappingType, selectableIndex, string, start, start + 1, returnEmbeddable, options);
                return start;
            }
            case '-': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                block16: for (int i = start + 1; i < string.length(); ++i) {
                    char digit = string.charAt(i);
                    switch (digit) {
                        case '.': {
                            return JsonHelper.consumeFractional(string, start, i, values, embeddableMappingType, selectableIndex, returnEmbeddable, options);
                        }
                        case 'E': 
                        case 'e': {
                            return JsonHelper.consumeExponential(string, start, i, values, embeddableMappingType, selectableIndex, returnEmbeddable, options);
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            continue block16;
                        }
                        default: {
                            values[selectableIndex] = JsonHelper.fromString(embeddableMappingType, selectableIndex, string, start, i, returnEmbeddable, options);
                            return i - 1;
                        }
                    }
                }
                break;
            }
        }
        return -1;
    }

    private static int consumeFractional(String string, int start, int dotIndex, Object[] values, EmbeddableMappingType embeddableMappingType, int selectableIndex, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        block4: for (int i = dotIndex + 1; i < string.length(); ++i) {
            char digit = string.charAt(i);
            switch (digit) {
                case 'E': 
                case 'e': {
                    return JsonHelper.consumeExponential(string, start, i, values, embeddableMappingType, selectableIndex, returnEmbeddable, options);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block4;
                }
                default: {
                    values[selectableIndex] = JsonHelper.fromString(embeddableMappingType, selectableIndex, string, start, i, returnEmbeddable, options);
                    return i - 1;
                }
            }
        }
        return start;
    }

    private static int consumeExponential(String string, int start, int eIndex, Object[] values, EmbeddableMappingType embeddableMappingType, int selectableIndex, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        int i = eIndex + 1;
        switch (string.charAt(i)) {
            case '+': 
            case '-': {
                ++i;
            }
        }
        while (i < string.length()) {
            char digit = string.charAt(i);
            switch (digit) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    values[selectableIndex] = JsonHelper.fromString(embeddableMappingType, selectableIndex, string, start, i, returnEmbeddable, options);
                    return i - 1;
                }
            }
            ++i;
        }
        return start;
    }

    private static int consume(String string, int start, String text) {
        if (!string.regionMatches(start + 1, text, 1, text.length() - 1)) {
            throw new IllegalArgumentException(String.format("Syntax error at position %d. Unexpected char [%s]. Expecting [%s]", start + 1, Character.valueOf(string.charAt(start + 1)), text));
        }
        return start + text.length() - 1;
    }

    private static IllegalArgumentException syntaxError(String string, State s, int charIndex) {
        return new IllegalArgumentException(String.format("Syntax error at position %d. Unexpected char [%s]. Expecting one of [%s]", charIndex, Character.valueOf(string.charAt(charIndex)), s.expectedChars()));
    }

    private static int getSelectableMapping(EmbeddableMappingType embeddableMappingType, String string, int start, int end, boolean hasEscape) {
        String name = hasEscape ? JsonHelper.unescape(string, start, end) : string.substring(start, end);
        int selectableIndex = embeddableMappingType.getSelectableIndex(name);
        if (selectableIndex == -1) {
            throw new IllegalArgumentException(String.format("Could not find selectable [%s] in embeddable type [%s] for JSON processing.", name, embeddableMappingType.getMappedJavaType().getJavaTypeClass().getName()));
        }
        return selectableIndex;
    }

    private static Object fromString(EmbeddableMappingType embeddableMappingType, int selectableIndex, String string, int start, int end, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(selectableIndex);
        return JsonHelper.fromString(selectableMapping.getJdbcMapping(), string, start, end, returnEmbeddable, options);
    }

    private static Object fromString(JdbcMapping jdbcMapping, String string, int start, int end, boolean hasEscape, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        if (hasEscape) {
            String unescaped = JsonHelper.unescape(string, start, end);
            return JsonHelper.fromString(jdbcMapping, unescaped, 0, unescaped.length(), returnEmbeddable, options);
        }
        return JsonHelper.fromString(jdbcMapping, string, start, end, returnEmbeddable, options);
    }

    private static Object fromString(JdbcMapping jdbcMapping, String string, int start, int end, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case -4: 
            case -3: 
            case -2: 
            case 4003: {
                return jdbcMapping.getJdbcJavaType().wrap((byte[])PrimitiveByteArrayJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 91: {
                return jdbcMapping.getJdbcJavaType().wrap(JdbcDateJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 92: 
            case 2013: 
            case 3007: {
                return jdbcMapping.getJdbcJavaType().wrap(JdbcTimeJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 93: {
                return jdbcMapping.getJdbcJavaType().wrap(JdbcTimestampJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case 2014: 
            case 3003: {
                return jdbcMapping.getJdbcJavaType().wrap(OffsetDateTimeJavaType.INSTANCE.fromEncodedString(string, start, end), options);
            }
            case -6: 
            case 4: 
            case 5: {
                Class javaTypeClass = jdbcMapping.getJavaTypeDescriptor().getJavaTypeClass();
                if (javaTypeClass == Boolean.class) {
                    return Integer.parseInt(string, start, end, 10) == 1;
                }
                if (javaTypeClass.isEnum()) {
                    return javaTypeClass.getEnumConstants()[Integer.parseInt(string, start, end, 10)];
                }
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (jdbcMapping.getJavaTypeDescriptor().getJavaTypeClass() != Boolean.class) break;
                return end == start + 1 && string.charAt(start) == 'Y';
            }
        }
        if (jdbcMapping.getJdbcType() instanceof AggregateJdbcType) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)jdbcMapping.getJdbcType();
            Object[] subValues = aggregateJdbcType.extractJdbcValues(CharSequenceHelper.subSequence(string, start, end), options);
            if (returnEmbeddable) {
                EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                return embeddableMappingType.getRepresentationStrategy().getInstantiator().instantiate(() -> subValues, options.getSessionFactory());
            }
            return subValues;
        }
        return jdbcMapping.getJdbcJavaType().fromEncodedString(string, start, end);
    }

    private static String unescape(String string, int start, int end) {
        StringBuilder sb = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                char cNext = string.charAt(++i);
                switch (cNext) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        sb.append(cNext);
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'u': {
                        sb.append((char)Integer.parseInt(string, i + 1, i + 5, 16));
                        i += 4;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static class JsonAppender
    extends OutputStream
    implements SqlAppender {
        private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        private final StringBuilder sb;
        private boolean escape;

        public JsonAppender(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void appendSql(String fragment) {
            this.append(fragment);
        }

        @Override
        public void appendSql(char fragment) {
            this.append(fragment);
        }

        @Override
        public void appendSql(int value) {
            this.sb.append(value);
        }

        @Override
        public void appendSql(long value) {
            this.sb.append(value);
        }

        @Override
        public void appendSql(boolean value) {
            this.sb.append(value);
        }

        public String toString() {
            return this.sb.toString();
        }

        public void startEscaping() {
            assert (!this.escape);
            this.escape = true;
        }

        public void endEscaping() {
            assert (this.escape);
            this.escape = false;
        }

        @Override
        public JsonAppender append(char fragment) {
            if (this.escape) {
                this.appendEscaped(fragment);
            } else {
                this.sb.append(fragment);
            }
            return this;
        }

        @Override
        public JsonAppender append(CharSequence csq) {
            return this.append(csq, 0, csq.length());
        }

        @Override
        public JsonAppender append(CharSequence csq, int start, int end) {
            if (this.escape) {
                int len = end - start;
                this.sb.ensureCapacity(this.sb.length() + len);
                for (int i = start; i < end; ++i) {
                    this.appendEscaped(csq.charAt(i));
                }
            } else {
                this.sb.append(csq, start, end);
            }
            return this;
        }

        @Override
        public void write(int v) {
            String hex = Integer.toHexString(v);
            this.sb.ensureCapacity(this.sb.length() + hex.length() + 1);
            if ((hex.length() & 1) == 1) {
                this.sb.append('0');
            }
            this.sb.append(hex);
        }

        @Override
        public void write(byte[] bytes) {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) {
            this.sb.ensureCapacity(this.sb.length() + (len << 1));
            for (int i = 0; i < len; ++i) {
                int v = bytes[off + i] & 0xFF;
                this.sb.append(HEX_ARRAY[v >>> 4]);
                this.sb.append(HEX_ARRAY[v & 0xF]);
            }
        }

        private void appendEscaped(char fragment) {
            switch (fragment) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\u000b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    this.sb.append("\\u").append(Integer.toHexString(fragment));
                    break;
                }
                case '\b': {
                    this.sb.append("\\b");
                    break;
                }
                case '\t': {
                    this.sb.append("\\t");
                    break;
                }
                case '\n': {
                    this.sb.append("\\n");
                    break;
                }
                case '\f': {
                    this.sb.append("\\f");
                    break;
                }
                case '\r': {
                    this.sb.append("\\r");
                    break;
                }
                case '\"': {
                    this.sb.append("\\\"");
                    break;
                }
                case '\\': {
                    this.sb.append("\\\\");
                    break;
                }
                default: {
                    this.sb.append(fragment);
                }
            }
        }
    }

    static enum State {
        KEY_START("\"\\s"),
        KEY_QUOTE(""),
        KEY_END(":\\s"),
        VALUE_START("\"\\s"),
        VALUE_QUOTE(""),
        VALUE_END(",}\\s");

        final String expectedChars;

        private State(String expectedChars) {
            this.expectedChars = expectedChars;
        }

        String expectedChars() {
            return this.expectedChars;
        }
    }
}

