/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class BatchFetchQueueHelper {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, BatchFetchQueueHelper.class.getName());

    private BatchFetchQueueHelper() {
    }

    public static void removeNotFoundBatchLoadableEntityKeys(Serializable[] ids, List<?> results, EntityPersister persister, SharedSessionContractImplementor session) {
        if (ids.length != results.size() && session.getLoadQueryInfluencers().effectivelyBatchLoadable(persister)) {
            LOG.debug("Not all entities were loaded.");
            HashSet<Serializable> idSet = new HashSet<Serializable>(Arrays.asList(ids));
            for (Object obj : results) {
                idSet.remove(session.getContextEntityIdentifier(obj));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Entities of type [" + persister.getEntityName() + "] not found; IDs: " + idSet);
            }
            for (Object object : idSet) {
                BatchFetchQueueHelper.removeBatchLoadableEntityKey(object, persister, session);
            }
        }
    }

    public static void removeBatchLoadableEntityKey(Object id, EntityPersister persister, SharedSessionContractImplementor session) {
        session.getPersistenceContextInternal().getBatchFetchQueue().removeBatchLoadableEntityKey(session.generateEntityKey(id, persister));
    }

    public static void removeBatchLoadableEntityKey(EntityKey entityKey, SharedSessionContractImplementor session) {
        session.getPersistenceContextInternal().getBatchFetchQueue().removeBatchLoadableEntityKey(entityKey);
    }

    public static void removeBatchLoadableEntityKey(Object id, EntityMappingType entityMappingType, SharedSessionContractImplementor session) {
        BatchFetchQueueHelper.removeBatchLoadableEntityKey(id, entityMappingType.getEntityPersister(), session);
    }
}

