/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.HibernateException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.AdditionalJaxbMappingProducer;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.envers.boot.EnversBootLogger;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class AdditionalJaxbMappingProducerImpl
implements AdditionalJaxbMappingProducer {
    private static final Logger log = Logger.getLogger(AdditionalJaxbMappingProducerImpl.class);

    @Override
    public Collection<MappingDocument> produceAdditionalMappings(MetadataImplementor metadata, IndexView jandexIndex, MappingBinder mappingBinder, final MetadataBuildingContext buildingContext) {
        MetadataBuildingOptions metadataBuildingOptions = metadata.getMetadataBuildingOptions();
        StandardServiceRegistry serviceRegistry = metadataBuildingOptions.getServiceRegistry();
        EnversService enversService = serviceRegistry.getService(EnversService.class);
        if (!enversService.isEnabled()) {
            return Collections.emptyList();
        }
        if (!metadataBuildingOptions.isXmlMappingEnabled()) {
            throw new HibernateException("Hibernate Envers currently requires XML mapping to be enabled. Please don't disable setting `hibernate.xml_mapping_enabled`; alternatively disable Hibernate Envers.");
        }
        final ArrayList<MappingDocument> additionalMappingDocuments = new ArrayList<MappingDocument>();
        final Origin origin = new Origin(SourceType.OTHER, "envers");
        MappingCollector mappingCollector = new MappingCollector(){

            @Override
            public void addDocument(JaxbHbmHibernateMapping mapping) {
                log.infof("Adding JAXB document mapping", new Object[0]);
                try {
                    JAXBContext context = JAXBContext.newInstance(JaxbHbmHibernateMapping.class);
                    Marshaller marshaller = context.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    StringWriter sw = new StringWriter();
                    marshaller.marshal((Object)mapping, sw);
                    EnversBootLogger.BOOT_LOGGER.jaxbContribution(sw.toString());
                    log.trace("------------------------------------------------------------");
                }
                catch (JAXBException e) {
                    throw new RuntimeException("Error dumping enhanced class", e);
                }
                additionalMappingDocuments.add(new MappingDocument("envers", mapping, origin, buildingContext));
            }
        };
        enversService.initialize(metadata, mappingCollector);
        return additionalMappingDocuments;
    }
}

