/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import org.hibernate.HibernateException;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.AdditionalMappingContributions;
import org.hibernate.boot.spi.AdditionalMappingContributor;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.envers.boot.internal.EnversService;

public class AdditionalMappingContributorImpl
implements AdditionalMappingContributor {
    @Override
    public String getContributorName() {
        return "envers";
    }

    @Override
    public void contribute(AdditionalMappingContributions contributions, InFlightMetadataCollector metadata, ResourceStreamLocator resourceStreamLocator, MetadataBuildingContext buildingContext) {
        MetadataBuildingOptions metadataBuildingOptions = metadata.getMetadataBuildingOptions();
        StandardServiceRegistry serviceRegistry = metadataBuildingOptions.getServiceRegistry();
        EnversService enversService = serviceRegistry.getService(EnversService.class);
        if (!enversService.isEnabled()) {
            return;
        }
        if (!metadataBuildingOptions.isXmlMappingEnabled()) {
            throw new HibernateException("Hibernate Envers currently requires XML mapping to be enabled. Please don't disable setting `hibernate.xml_mapping_enabled`; alternatively disable Hibernate Envers.");
        }
        enversService.initialize(metadata, contributions::contributeBinding);
    }
}

