/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBasicAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeKeyBasicAttributeType;
import org.hibernate.envers.boot.model.Column;
import org.hibernate.envers.boot.model.Keyable;
import org.hibernate.envers.boot.model.SingularAttribute;
import org.hibernate.envers.boot.model.TypeSpecification;

public class BasicAttribute
implements SingularAttribute,
Keyable {
    private final List<Column> columns;
    private final boolean updatable;
    private final String explicitType;
    private String name;
    private final String type;
    private boolean insertable;
    private boolean key;
    private TypeSpecification typeDefinition;

    public BasicAttribute(String name, String type, boolean insertable, boolean key) {
        this(name, type, insertable, false, key);
    }

    public BasicAttribute(String name, String type, boolean insertable, boolean key, String explicitType) {
        this(name, type, insertable, false, key, explicitType);
    }

    public BasicAttribute(String name, String type, boolean insertable, boolean updatable, boolean key) {
        this(name, type, insertable, updatable, key, null);
    }

    public BasicAttribute(String name, String type, boolean insertable, boolean updatable, boolean key, String explicitType) {
        this.name = name;
        this.type = type;
        this.insertable = insertable;
        this.updatable = updatable;
        this.key = key;
        this.explicitType = explicitType;
        this.columns = new ArrayList<Column>();
    }

    public BasicAttribute(BasicAttribute other) {
        this.name = other.name;
        this.type = other.type;
        this.explicitType = other.explicitType;
        this.insertable = other.insertable;
        this.updatable = other.updatable;
        this.key = other.key;
        if (other.typeDefinition != null) {
            this.typeDefinition = new TypeSpecification(other.typeDefinition);
        }
        this.columns = new ArrayList<Column>();
        other.columns.forEach(c -> this.columns.add(c.deepCopy()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setKey(boolean key) {
        this.key = key;
    }

    @Override
    public boolean isKey() {
        return this.key;
    }

    @Override
    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public TypeSpecification getType() {
        return this.typeDefinition;
    }

    public void setType(TypeSpecification type) {
        this.typeDefinition = type;
    }

    @Override
    public BasicAttribute deepCopy() {
        return new BasicAttribute(this);
    }

    @Override
    public Serializable build() {
        if (this.key) {
            return this.buildCompositeKeyBasicAttribute();
        }
        return this.buildBasicAttribute();
    }

    private JaxbHbmCompositeKeyBasicAttributeType buildCompositeKeyBasicAttribute() {
        JaxbHbmCompositeKeyBasicAttributeType basic = new JaxbHbmCompositeKeyBasicAttributeType();
        basic.setName(this.name);
        basic.setTypeAttribute(this.resolveType());
        for (Column column : this.columns) {
            basic.getColumn().add(column.build());
        }
        if (this.typeDefinition != null) {
            basic.setType(this.typeDefinition.build());
        }
        return basic;
    }

    private JaxbHbmBasicAttributeType buildBasicAttribute() {
        JaxbHbmBasicAttributeType basic = new JaxbHbmBasicAttributeType();
        basic.setName(this.name);
        basic.setTypeAttribute(this.resolveType());
        basic.setInsert(this.insertable);
        basic.setUpdate(this.updatable);
        for (Column column : this.columns) {
            basic.getColumnOrFormula().add(column.build());
        }
        if (this.typeDefinition != null) {
            basic.setType(this.typeDefinition.build());
        }
        return basic;
    }

    private String resolveType() {
        return this.explicitType == null ? this.type : this.explicitType;
    }
}

