/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmColumnType;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.model.Cloneable;
import org.hibernate.envers.boot.model.Selection;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.mapping.Selectable;

public class Column
extends Selection<JaxbHbmColumnType>
implements Cloneable<Column> {
    private final Long length;
    private final Integer scale;
    private final Integer precision;
    private final String sqlType;
    private final String read;
    private final String write;
    private String name;

    public Column(String name) {
        this(name, false);
    }

    public Column(String name, boolean quoted) {
        this(name, null, null, null, null, null, null, quoted);
    }

    public Column(String name, Long length, Integer scale, Integer precision, String sqlType, String read, String write) {
        this(name, length, scale, precision, sqlType, read, write, false);
    }

    public Column(String name, Long length, Integer scale, Integer precision, String sqlType, String read, String write, boolean quoted) {
        super(Selection.SelectionType.COLUMN);
        this.name = quoted ? Column.getQuotedName(name) : name;
        this.length = length;
        this.scale = scale;
        this.precision = precision;
        this.sqlType = sqlType;
        this.read = read;
        this.write = write;
    }

    public Column(Column other) {
        super(other.getSelectionType());
        this.name = other.name;
        this.length = other.length;
        this.scale = other.scale;
        this.precision = other.precision;
        this.sqlType = other.sqlType;
        this.read = other.read;
        this.write = other.write;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Column deepCopy() {
        return new Column(this);
    }

    @Override
    public JaxbHbmColumnType build() {
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(this.name);
        if (this.length != null) {
            column.setLength(this.length.intValue());
        }
        if (this.scale != null) {
            column.setScale(this.scale);
        }
        if (this.precision != null) {
            column.setPrecision(this.precision);
        }
        if (!StringTools.isEmpty(this.sqlType)) {
            column.setSqlType(this.sqlType);
        }
        if (!StringTools.isEmpty(this.read)) {
            column.setRead(this.read);
        }
        if (!StringTools.isEmpty(this.write)) {
            column.setWrite(this.write);
        }
        return column;
    }

    public static Column from(Selectable selectable) {
        if (!(selectable instanceof org.hibernate.mapping.Column)) {
            throw new EnversMappingException("Cannot create audit column mapping from " + selectable.getClass().getName());
        }
        org.hibernate.mapping.Column column = (org.hibernate.mapping.Column)selectable;
        return new Column(column.getName(), column.getLength(), column.getScale(), column.getPrecision(), column.getSqlType(), column.getCustomRead(), column.getCustomWrite(), column.isQuoted());
    }

    private static String getQuotedName(String name) {
        return "`" + name + "`";
    }
}

