/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmKeyType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSecondaryTableType;
import org.hibernate.envers.boot.model.Attribute;
import org.hibernate.envers.boot.model.AttributeContainer;
import org.hibernate.envers.boot.model.Bindable;
import org.hibernate.envers.boot.model.Column;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;

public class Join
implements AttributeContainer,
Bindable<JaxbHbmSecondaryTableType> {
    private final List<Column> keyColumns;
    private final List<Attribute> attributes;
    private boolean inverse;
    private boolean optional;
    private String tableName;
    private String schema;
    private String catalog;

    public Join(String catalogName, String schemaName, String tableName) {
        this.catalog = catalogName;
        this.schema = schemaName;
        this.tableName = tableName;
        this.keyColumns = new ArrayList<Column>();
        this.attributes = new ArrayList<Attribute>();
    }

    @Override
    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public void setTable(String tableName) {
        this.tableName = tableName;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    public void addKeyColumn(Column keyColumn) {
        this.keyColumns.add(keyColumn);
    }

    public void addKeyColumnsFromValue(Value value) {
        List<Selectable> selectables = value.getSelectables();
        for (Selectable s : selectables) {
            this.keyColumns.add(Column.from(s));
        }
    }

    @Override
    public JaxbHbmSecondaryTableType build() {
        JaxbHbmSecondaryTableType join = new JaxbHbmSecondaryTableType();
        if (!StringTools.isEmpty(this.catalog)) {
            join.setCatalog(this.catalog);
        }
        if (!StringTools.isEmpty(this.schema)) {
            join.setSchema(this.schema);
        }
        join.setTable(this.tableName);
        join.setOptional(this.optional);
        join.setInverse(this.inverse);
        JaxbHbmKeyType key = new JaxbHbmKeyType();
        join.setKey(key);
        for (Column keyColumn : this.keyColumns) {
            key.getColumn().add(keyColumn.build());
        }
        for (Attribute attribute : this.attributes) {
            join.getAttributes().add((Serializable)attribute.build());
        }
        return join;
    }
}

