/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.boot.EnversMappingException;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.boot.internal.LegacyModifiedColumnNamingStrategy;
import org.hibernate.envers.boot.spi.ModifiedColumnNamingStrategy;
import org.hibernate.envers.configuration.internal.RevisionInfoConfiguration;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.strategy.DefaultAuditStrategy;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class Configuration {
    private static final String OPERATOR_IN = "in";
    private static final String OPERATOR_EQUALS = "=";
    private static final String DEFAULT_PREFIX = "";
    private static final String DEFAULT_SUFFIX = "_AUD";
    private static final String DEFAULT_MODIFIED_FLAG_SUFFIX = "_MOD";
    private static final String DEFAULT_ORIGINAL_ID = "originalId";
    private static final String DEFAULT_REV_FIELD = "REV";
    private static final String DEFAULT_REVTYPE_FIELD = "REVTYPE";
    private static final String DEFAULT_REVTYPE_TYPE = "byte";
    private static final String DEFAULT_REVEND_FIELD = "REVEND";
    private static final String DEFAULT_REV_TSTMP_FIELD = "REVEND_TSTMP";
    private static final String DEFAULT_SETORDINAL_FIELD = "SETORDINAL";
    private final EnversService enversService;
    private final String defaultCatalogName;
    private final String defaultSchemaName;
    private final String modifiedFlagsSuffix;
    private final String correlatedSubqueryOperator;
    private final Class<? extends RevisionListener> revisionListenerClass;
    private final AuditStrategy auditStrategy;
    private final ModifiedColumnNamingStrategy modifiedColumnNamingStrategy;
    private final boolean nativeIdEnabled;
    private final boolean allowIdentifierReuse;
    private final boolean generateRevisionsForCollections;
    private final boolean doNotAuditOptimisticLockingField;
    private final boolean storeDeleteData;
    private final boolean cascadeDeleteRevision;
    private final boolean modifiedFlagsEnabled;
    private final boolean modifiedFlagsDefined;
    private final boolean findByRevisionExactMatch;
    private final boolean globalLegacyRelationTargetNotFound;
    private final boolean trackEntitiesChanged;
    private boolean trackEntitiesOverride;
    private final String auditTablePrefix;
    private final String auditTableSuffix;
    private final String originalIdPropertyName;
    private final String revisionFieldName;
    private final String revisionNumberPath;
    private final String revisionPropertyBasePath;
    private final String revisionTypePropertyName;
    private final String revisionTypePropertyType;
    private final String revisionEndFieldName;
    private final String revisionEndTimestampFieldName;
    private final String embeddableSetOrdinalPropertyName;
    private final boolean revisionEndTimestampEnabled;
    private final boolean revisionEndTimestampNumeric;
    private final boolean revisionEndTimestampUseLegacyPlacement;
    private final boolean revisionSequenceNoCache;
    private final Map<String, String> customAuditTableNames = new HashMap<String, String>();
    private final RevisionInfoConfiguration revisionInfo;

    public Configuration(Properties properties, EnversService enversService, MetadataImplementor metadata) {
        this.enversService = enversService;
        ConfigurationProperties configProps = new ConfigurationProperties(properties);
        this.defaultCatalogName = configProps.getString("org.hibernate.envers.default_catalog");
        this.defaultSchemaName = configProps.getString("org.hibernate.envers.default_schema");
        this.correlatedSubqueryOperator = Configuration.resolveCorrelatedSubqueryOperator(properties);
        this.modifiedFlagsSuffix = configProps.getString("org.hibernate.envers.modified_flag_suffix", DEFAULT_MODIFIED_FLAG_SUFFIX);
        this.revisionListenerClass = Configuration.resolveRevisionListener(configProps, enversService);
        StrategySelector strategySelector = enversService.getServiceRegistry().getService(StrategySelector.class);
        this.modifiedColumnNamingStrategy = Configuration.resolveModifiedColumnNamingStrategy(configProps, strategySelector);
        this.auditStrategy = Configuration.resolveAuditStrategy(configProps, strategySelector);
        this.nativeIdEnabled = configProps.getBoolean("org.hibernate.envers.use_revision_entity_with_native_id", true);
        this.allowIdentifierReuse = configProps.getBoolean("org.hibernate.envers.allow_identifier_reuse", false);
        this.generateRevisionsForCollections = configProps.getBoolean("org.hibernate.envers.revision_on_collection_change", true);
        this.doNotAuditOptimisticLockingField = configProps.getBoolean("org.hibernate.envers.do_not_audit_optimistic_locking_field", true);
        this.storeDeleteData = configProps.getBoolean("org.hibernate.envers.store_data_at_delete", false);
        this.cascadeDeleteRevision = configProps.getBoolean("org.hibernate.envers.cascade_delete_revision", false);
        this.trackEntitiesChanged = configProps.getBoolean("org.hibernate.envers.track_entities_changed_in_revision", false);
        this.modifiedFlagsDefined = properties.get("org.hibernate.envers.global_with_modified_flag") != null;
        this.modifiedFlagsEnabled = configProps.getBoolean("org.hibernate.envers.global_with_modified_flag", false);
        this.findByRevisionExactMatch = configProps.getBoolean("org.hibernate.envers.find_by_revision_exact_match", false);
        this.globalLegacyRelationTargetNotFound = configProps.getBoolean("org.hibernate.envers.global_relation_not_found_legacy_flag", true);
        this.auditTablePrefix = configProps.getString("org.hibernate.envers.audit_table_prefix", DEFAULT_PREFIX);
        this.auditTableSuffix = configProps.getString("org.hibernate.envers.audit_table_suffix", DEFAULT_SUFFIX);
        this.originalIdPropertyName = configProps.getString("org.hibernate.envers.original_id_prop_name", DEFAULT_ORIGINAL_ID);
        this.revisionFieldName = configProps.getString("org.hibernate.envers.revision_field_name", DEFAULT_REV_FIELD);
        this.revisionTypePropertyName = configProps.getString("org.hibernate.envers.revision_type_field_name", DEFAULT_REVTYPE_FIELD);
        this.revisionTypePropertyType = DEFAULT_REVTYPE_TYPE;
        this.revisionEndFieldName = configProps.getString("org.hibernate.envers.audit_strategy_validity_end_rev_field_name", DEFAULT_REVEND_FIELD);
        this.revisionEndTimestampEnabled = configProps.getBoolean("org.hibernate.envers.audit_strategy_validity_store_revend_timestamp", false);
        if (this.revisionEndTimestampEnabled) {
            this.revisionEndTimestampFieldName = configProps.getString("org.hibernate.envers.audit_strategy_validity_revend_timestamp_field_name", DEFAULT_REV_TSTMP_FIELD);
            this.revisionEndTimestampNumeric = configProps.getBoolean("org.hibernate.envers.audit_strategy_validity_revend_timestamp_numeric", false);
            this.revisionEndTimestampUseLegacyPlacement = configProps.getBoolean("org.hibernate.envers.audit_strategy_validity_revend_timestamp_legacy_placement", true);
        } else {
            this.revisionEndTimestampFieldName = null;
            this.revisionEndTimestampNumeric = false;
            this.revisionEndTimestampUseLegacyPlacement = true;
        }
        this.embeddableSetOrdinalPropertyName = configProps.getString("org.hibernate.envers.embeddable_set_ordinal_field_name", DEFAULT_SETORDINAL_FIELD);
        this.revisionSequenceNoCache = configProps.getBoolean("org.hibernate.envers.revision_sequence_nocache", false);
        this.revisionPropertyBasePath = this.originalIdPropertyName + "." + this.revisionFieldName + ".";
        this.revisionNumberPath = this.revisionPropertyBasePath + "id";
        ReflectionManager reflectionManager = metadata.getMetadataBuildingOptions().getTypeConfiguration().getMetadataBuildingContext().getBootstrapContext().getReflectionManager();
        this.revisionInfo = new RevisionInfoConfiguration(this, metadata, reflectionManager);
    }

    public boolean isGenerateRevisionsForCollections() {
        return this.generateRevisionsForCollections;
    }

    public boolean isDoNotAuditOptimisticLockingField() {
        return this.doNotAuditOptimisticLockingField;
    }

    public boolean isStoreDataAtDelete() {
        return this.storeDeleteData;
    }

    public boolean isTrackEntitiesChanged() {
        return this.trackEntitiesOverride ? this.trackEntitiesOverride : this.trackEntitiesChanged;
    }

    public void setTrackEntitiesChanged(boolean trackEntitiesChanged) {
        this.trackEntitiesOverride = trackEntitiesChanged;
    }

    public boolean hasSettingForUseModifiedFlag() {
        return this.modifiedFlagsDefined;
    }

    public boolean isModifiedFlagsEnabled() {
        return this.modifiedFlagsEnabled;
    }

    public boolean isNativeIdEnabled() {
        return this.nativeIdEnabled;
    }

    public boolean isCascadeDeleteRevision() {
        return this.cascadeDeleteRevision;
    }

    public boolean isAllowIdentifierReuse() {
        return this.allowIdentifierReuse;
    }

    public boolean isFindByRevisionExactMatch() {
        return this.findByRevisionExactMatch;
    }

    public boolean isGlobalLegacyRelationTargetNotFound() {
        return this.globalLegacyRelationTargetNotFound;
    }

    public boolean isRevisionEndTimestampEnabled() {
        return this.revisionEndTimestampEnabled;
    }

    public boolean isRevisionEndTimestampNumeric() {
        return this.revisionEndTimestampNumeric;
    }

    public boolean isRevisionEndTimestampUseLegacyPlacement() {
        return this.revisionEndTimestampUseLegacyPlacement;
    }

    public boolean isRevisionSequenceNoCache() {
        return this.revisionSequenceNoCache;
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public String getCorrelatedSubqueryOperator() {
        return this.correlatedSubqueryOperator;
    }

    public String getModifiedFlagsSuffix() {
        return this.modifiedFlagsSuffix;
    }

    public String getOriginalIdPropertyName() {
        return this.originalIdPropertyName;
    }

    public String getRevisionFieldName() {
        return this.revisionFieldName;
    }

    public String getRevisionEndTimestampFieldName() {
        return this.revisionEndTimestampFieldName;
    }

    public String getRevisionEndFieldName() {
        return this.revisionEndFieldName;
    }

    public String getRevisionNumberPath() {
        return this.revisionNumberPath;
    }

    public String getRevisionPropertyPath(String propertyName) {
        return this.revisionPropertyBasePath + propertyName;
    }

    public String getRevisionTypePropertyName() {
        return this.revisionTypePropertyName;
    }

    public String getRevisionTypePropertyType() {
        return this.revisionTypePropertyType;
    }

    public String getAuditEntityName(String entityName) {
        return this.auditTablePrefix + entityName + this.auditTableSuffix;
    }

    public void addCustomAuditTableName(String entityName, String tableName) {
        this.customAuditTableNames.put(entityName, tableName);
    }

    public String getAuditTableName(String entityName, String tableName) {
        String existingName = this.customAuditTableNames.get(entityName);
        if (existingName != null) {
            return existingName;
        }
        return this.getAuditEntityName(tableName);
    }

    public String getAuditStrategyName() {
        return this.auditStrategy.getClass().getName();
    }

    public String getEmbeddableSetOrdinalPropertyName() {
        return this.embeddableSetOrdinalPropertyName;
    }

    public Class<? extends RevisionListener> getRevisionListenerClass() {
        return this.revisionListenerClass;
    }

    public AuditStrategy getAuditStrategy() {
        return this.auditStrategy;
    }

    public ModifiedColumnNamingStrategy getModifiedColumnNamingStrategy() {
        return this.modifiedColumnNamingStrategy;
    }

    public RevisionInfoConfiguration getRevisionInfo() {
        return this.revisionInfo;
    }

    public EnversService getEnversService() {
        return this.enversService;
    }

    private static String resolveCorrelatedSubqueryOperator(Properties properties) {
        if (HSQLDialect.class.getName().equals(properties.get("hibernate.dialect"))) {
            return OPERATOR_IN;
        }
        return OPERATOR_EQUALS;
    }

    private static Class<? extends RevisionListener> resolveRevisionListener(ConfigurationProperties configProps, EnversService enversService) {
        String className = configProps.getString("org.hibernate.envers.revision_listener");
        if (!StringTools.isEmpty(className)) {
            try {
                return ReflectionTools.loadClass(className, enversService.getClassLoaderService());
            }
            catch (ClassLoadingException e) {
                throw new EnversMappingException("Revision listener class not found: " + className + ".");
            }
        }
        return null;
    }

    private static ModifiedColumnNamingStrategy resolveModifiedColumnNamingStrategy(ConfigurationProperties configProps, StrategySelector selector) {
        return selector.resolveDefaultableStrategy(ModifiedColumnNamingStrategy.class, (Object)configProps.getString("org.hibernate.envers.modified_column_naming_strategy"), () -> selector.resolveDefaultableStrategy(ModifiedColumnNamingStrategy.class, (Object)"default", new LegacyModifiedColumnNamingStrategy()));
    }

    private static AuditStrategy resolveAuditStrategy(ConfigurationProperties configProps, StrategySelector selector) {
        return selector.resolveDefaultableStrategy(AuditStrategy.class, (Object)configProps.getString("org.hibernate.envers.audit_strategy", DefaultAuditStrategy.class.getName()), () -> new DefaultAuditStrategy());
    }

    private static class ConfigurationProperties {
        private final Properties properties;

        private ConfigurationProperties(Properties properties) {
            this.properties = properties;
        }

        String getString(String propertyName) {
            return ConfigurationHelper.getString(propertyName, this.properties);
        }

        String getString(String propertyName, String defaultValue) {
            return ConfigurationHelper.getString(propertyName, (Map)this.properties, defaultValue);
        }

        boolean getBoolean(String propertyName, boolean defaultValue) {
            return ConfigurationHelper.getBoolean(propertyName, this.properties, defaultValue);
        }

        boolean getBooleanWithFallback(String basePropertyName, String newPropertyName, boolean defaultValue) {
            if (!this.properties.containsKey(basePropertyName)) {
                return this.getBoolean(newPropertyName, defaultValue);
            }
            return ConfigurationHelper.getBoolean(basePropertyName, this.properties);
        }
    }
}

