/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.envers.boot.model.PersistentEntity;

public class EntityMappingData {
    private PersistentEntity entityDefinition;
    private final List<PersistentEntity> additionalEntityDefinitions;
    private final JaxbHbmHibernateMapping mapping = new JaxbHbmHibernateMapping();
    private final List<JaxbHbmHibernateMapping> additionalMappings;

    public EntityMappingData() {
        this.mapping.setAutoImport(false);
        this.additionalEntityDefinitions = new ArrayList<PersistentEntity>();
        this.additionalMappings = new ArrayList<JaxbHbmHibernateMapping>();
    }

    public PersistentEntity getEntityDefinition() {
        return this.entityDefinition;
    }

    public JaxbHbmHibernateMapping getMapping() {
        return this.mapping;
    }

    public List<JaxbHbmHibernateMapping> getAdditionalMappings() {
        return this.additionalMappings;
    }

    public void addMapping(PersistentEntity mapping) {
        this.entityDefinition = mapping;
    }

    public void addAdditionalMapping(PersistentEntity mapping) {
        this.additionalEntityDefinitions.add(mapping);
    }

    public void build() {
        this.entityDefinition.build(this.mapping);
        for (PersistentEntity additionalDefinition : this.additionalEntityDefinitions) {
            JaxbHbmHibernateMapping newMapping = new JaxbHbmHibernateMapping();
            this.additionalMappings.add(newMapping);
            additionalDefinition.build(newMapping);
        }
    }

    public boolean isRootEntity() {
        return !this.mapping.getClazz().isEmpty();
    }

    public boolean isSubclassEntity() {
        return !this.mapping.getSubclass().isEmpty();
    }

    public boolean isUnionSubclassEntity() {
        return !this.mapping.getUnionSubclass().isEmpty();
    }

    public boolean isJoinedSubclassEntity() {
        return !this.mapping.getJoinedSubclass().isEmpty();
    }

    public boolean isEntityTypeKnown() {
        return !this.isRootEntity() && !this.isSubclassEntity() && !this.isUnionSubclassEntity() && !this.isJoinedSubclassEntity();
    }
}

