/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.Audited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.envers.SecondaryAuditTable;
import org.hibernate.envers.SecondaryAuditTables;
import org.hibernate.envers.boot.spi.EnversMetadataBuildingContext;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesReader;
import org.hibernate.envers.configuration.internal.metadata.reader.ClassAuditingData;
import org.hibernate.envers.configuration.internal.metadata.reader.PersistentPropertiesSource;
import org.hibernate.mapping.PersistentClass;

public final class AnnotationsMetadataReader {
    private final EnversMetadataBuildingContext metadataBuildingContext;
    private final AuditTable defaultAuditTable = new AuditTable(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public String schema() {
            return "";
        }

        @Override
        public String catalog() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }
    };

    public AnnotationsMetadataReader(EnversMetadataBuildingContext metadataBuildingContext) {
        this.metadataBuildingContext = metadataBuildingContext;
    }

    private RelationTargetAuditMode getDefaultAudited(XClass clazz) {
        Audited defaultAudited = clazz.getAnnotation(Audited.class);
        if (defaultAudited != null) {
            return defaultAudited.targetAuditMode();
        }
        return null;
    }

    private void addAuditTable(ClassAuditingData auditData, XClass clazz) {
        AuditTable auditTable = clazz.getAnnotation(AuditTable.class);
        if (auditTable != null) {
            auditData.setAuditTable(auditTable);
        } else {
            auditData.setAuditTable(this.getDefaultAuditTable());
        }
    }

    private void addAuditSecondaryTables(ClassAuditingData auditData, XClass clazz) {
        SecondaryAuditTables secondaryAuditTables;
        SecondaryAuditTable secondaryVersionsTable1 = clazz.getAnnotation(SecondaryAuditTable.class);
        if (secondaryVersionsTable1 != null) {
            auditData.getSecondaryTableDictionary().put(secondaryVersionsTable1.secondaryTableName(), secondaryVersionsTable1.secondaryAuditTableName());
        }
        if ((secondaryAuditTables = clazz.getAnnotation(SecondaryAuditTables.class)) != null) {
            for (SecondaryAuditTable secondaryAuditTable2 : secondaryAuditTables.value()) {
                auditData.getSecondaryTableDictionary().put(secondaryAuditTable2.secondaryTableName(), secondaryAuditTable2.secondaryAuditTableName());
            }
        }
    }

    public ClassAuditingData getAuditData(PersistentClass persistentClass) {
        ClassAuditingData auditData = new ClassAuditingData(persistentClass);
        XClass xclass = this.metadataBuildingContext.getReflectionManager().toXClass(persistentClass.getMappedClass());
        RelationTargetAuditMode auditMode = this.getDefaultAudited(xclass);
        if (auditMode != null) {
            auditData.setDefaultAudited(true);
        }
        new AuditedPropertiesReader(this.metadataBuildingContext, PersistentPropertiesSource.forClass(persistentClass, xclass), auditData).read();
        this.addAuditTable(auditData, xclass);
        this.addAuditSecondaryTables(auditData, xclass);
        return auditData;
    }

    private AuditTable getDefaultAuditTable() {
        return this.defaultAuditTable;
    }
}

