/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.enhanced;

import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.enhanced.SequenceStructure;

public class OrderedSequenceStructure
extends SequenceStructure {
    private final AuxiliaryDatabaseObject sequenceObject = new OrderedSequence();
    private final String suffix;

    public OrderedSequenceStructure(JdbcEnvironment jdbcEnvironment, QualifiedName qualifiedSequenceName, int initialValue, int incrementSize, Class<?> numberType) {
        this(jdbcEnvironment, qualifiedSequenceName, initialValue, incrementSize, false, numberType);
    }

    public OrderedSequenceStructure(JdbcEnvironment jdbcEnvironment, QualifiedName qualifiedSequenceName, int initialValue, int incrementSize, boolean noCache, Class<?> numberType) {
        super(jdbcEnvironment, "envers", qualifiedSequenceName, initialValue, incrementSize, numberType);
        Dialect dialect = DialectDelegateWrapper.extractRealDialect(jdbcEnvironment.getDialect());
        this.suffix = dialect instanceof OracleDialect ? (noCache ? " NOCACHE" : "") + " ORDER" : null;
    }

    @Override
    protected void buildSequence(Database database) {
        database.addAuxiliaryDatabaseObject(this.sequenceObject);
        this.physicalSequenceName = this.getQualifiedName();
    }

    private class OrderedSequence
    implements AuxiliaryDatabaseObject {
        private OrderedSequence() {
        }

        @Override
        public String getExportIdentifier() {
            return OrderedSequenceStructure.this.getQualifiedName().render();
        }

        @Override
        public boolean appliesToDialect(Dialect dialect) {
            return true;
        }

        @Override
        public boolean beforeTablesOnCreation() {
            return true;
        }

        @Override
        public String[] sqlCreateStrings(SqlStringGenerationContext context) {
            Dialect dialect = context.getDialect();
            String[] createStrings = dialect.getSequenceSupport().getCreateSequenceStrings(context.format(OrderedSequenceStructure.this.getPhysicalName()), OrderedSequenceStructure.this.getInitialValue(), OrderedSequenceStructure.this.getSourceIncrementSize());
            if (OrderedSequenceStructure.this.suffix != null) {
                for (int i = 0; i < createStrings.length; ++i) {
                    createStrings[i] = createStrings[i] + OrderedSequenceStructure.this.suffix;
                }
            }
            return createStrings;
        }

        @Override
        public String[] sqlDropStrings(SqlStringGenerationContext context) {
            Dialect dialect = context.getDialect();
            return dialect.getSequenceSupport().getDropSequenceStrings(context.format(OrderedSequenceStructure.this.getPhysicalName()));
        }
    }
}

