/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.spi;

import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.event.spi.EnversListener;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.envers.internal.synchronization.work.CollectionChangeWorkUnit;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public abstract class BaseEnversEventListener
implements EnversListener {
    private final EnversService enversService;

    protected BaseEnversEventListener(EnversService enversService) {
        this.enversService = enversService;
    }

    protected EnversService getEnversService() {
        return this.enversService;
    }

    protected final void generateBidirectionalCollectionChangeWorkUnits(AuditProcess auditProcess, EntityPersister entityPersister, String entityName, Object[] newState, Object[] oldState, SessionImplementor session) {
        if (!this.enversService.getConfig().isGenerateRevisionsForCollections()) {
            return;
        }
        String[] propertyNames = entityPersister.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            Object newValue;
            String propertyName = propertyNames[i];
            RelationDescription relDesc = this.enversService.getEntitiesConfigurations().getRelationDescription(entityName, propertyName);
            if (relDesc == null || !relDesc.isBidirectional() || relDesc.getRelationType() != RelationType.TO_ONE || !relDesc.isInsertable()) continue;
            Object oldValue = oldState == null ? null : oldState[i];
            Object object = newValue = newState == null ? null : newState[i];
            if (EntityTools.entitiesEqual(session, relDesc.getToEntityName(), oldValue, newValue)) continue;
            if (newValue != null) {
                this.addCollectionChangeWorkUnit(auditProcess, session, entityName, relDesc, newValue);
            }
            if (oldValue == null) continue;
            this.addCollectionChangeWorkUnit(auditProcess, session, entityName, relDesc, oldValue);
        }
    }

    private void addCollectionChangeWorkUnit(AuditProcess auditProcess, SessionImplementor session, String fromEntityName, RelationDescription relDesc, Object value) {
        String toEntityName;
        Object id;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(value);
        if (lazyInitializer != null) {
            id = lazyInitializer.getInternalIdentifier();
            value = EntityTools.getTargetFromProxy((SessionFactoryImplementor)session.getFactory(), lazyInitializer);
            toEntityName = session.bestGuessEntityName(value);
        } else {
            toEntityName = session.guessEntityName(value);
            IdMapper idMapper = this.enversService.getEntitiesConfigurations().get(toEntityName).getIdMapper();
            id = idMapper.mapToIdFromEntity(value);
        }
        Set<String> toPropertyNames = this.enversService.getEntitiesConfigurations().getToPropertyNames(fromEntityName, relDesc.getFromPropertyName(), toEntityName);
        String toPropertyName = toPropertyNames.iterator().next();
        auditProcess.addWorkUnit(new CollectionChangeWorkUnit(session, toEntityName, toPropertyName, this.enversService, id, value));
    }

    protected void checkIfTransactionInProgress(SessionImplementor session) {
        if (!session.isTransactionInProgress()) {
            throw new AuditException("Unable to create revision because of non-active transaction");
        }
    }
}

