/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.DelegatingTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;

public class OrderByFragmentFunction
extends AbstractSqmFunctionDescriptor {
    public static final String FUNCTION_NAME = "_order_by_frag";
    public static final OrderByFragmentFunction INSTANCE = new OrderByFragmentFunction();

    public OrderByFragmentFunction() {
        super(FUNCTION_NAME, StandardArgumentsValidators.exactly(2), StandardFunctionReturnTypeResolvers.useArgType(1), null);
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        return new OrderByFragmentSelfRenderingSqmFunction<T>(this, arguments, impliedResultType, queryEngine);
    }

    private static class OrderByFragmentSelfRenderingSqmFunction<T>
    extends SelfRenderingSqmFunction<T> {
        public OrderByFragmentSelfRenderingSqmFunction(OrderByFragmentFunction orderByFragmentFunction, List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
            super(orderByFragmentFunction, null, arguments, impliedResultType, orderByFragmentFunction.getArgumentsValidator(), orderByFragmentFunction.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), orderByFragmentFunction.getName());
        }

        private OrderByFragmentSelfRenderingSqmFunction(SqmFunctionDescriptor descriptor, FunctionRenderingSupport renderingSupport, List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
            super(descriptor, renderingSupport, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
        }

        @Override
        public OrderByFragmentSelfRenderingSqmFunction<T> copy(SqmCopyContext context) {
            OrderByFragmentSelfRenderingSqmFunction existing = context.getCopy(this);
            if (existing != null) {
                return existing;
            }
            ArrayList<SqmNode> arguments = new ArrayList<SqmNode>(this.getArguments().size());
            for (SqmTypedNode<?> argument : this.getArguments()) {
                arguments.add(argument.copy(context));
            }
            return context.registerCopy(this, new OrderByFragmentSelfRenderingSqmFunction(this.getFunctionDescriptor(), this.getRenderingSupport(), arguments, this.getImpliedResultType(), this.getArgumentsValidator(), this.getReturnTypeResolver(), this.nodeBuilder(), this.getFunctionName()));
        }

        @Override
        public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
            String sqmAlias = (String)((SqmLiteral)this.getArguments().get(0)).getLiteralValue();
            String attributeRole = (String)((SqmLiteral)this.getArguments().get(1)).getLiteralValue();
            TableGroup tableGroup = ((FromClauseIndex)walker.getFromClauseAccess()).findTableGroup(sqmAlias);
            QueryableCollection collectionDescriptor = (QueryableCollection)walker.getCreationContext().getSessionFactory().getRuntimeMetamodels().getMappingMetamodel().findCollectionDescriptor(attributeRole);
            PluralAttributeMapping pluralAttribute = collectionDescriptor.getAttributeMapping();
            QuerySpec queryPart = (QuerySpec)((SqlAstQueryPartProcessingState)walker.getCurrentProcessingState()).getInflightQueryPart();
            OrderByFragment fragment = pluralAttribute.getOrderByFragment() != null ? pluralAttribute.getOrderByFragment() : pluralAttribute.getManyToManyOrderByFragment();
            String targetTableExpression = collectionDescriptor.getElementPersister() == null ? collectionDescriptor.getTableName() : ((Joinable)((Object)collectionDescriptor.getElementPersister())).getTableName();
            fragment.apply(queryPart, new AuditingTableGroup(tableGroup, targetTableExpression), walker);
            return null;
        }
    }

    private static class AuditingTableGroup
    extends DelegatingTableGroup {
        private final TableGroup delegate;
        private final String auditTableExpression;
        private final String normalTableExpression;

        public AuditingTableGroup(TableGroup delegate, String normalTableExpression) {
            this.delegate = delegate;
            this.auditTableExpression = ((NamedTableReference)delegate.getPrimaryTableReference()).getTableExpression();
            this.normalTableExpression = normalTableExpression;
        }

        @Override
        protected TableGroup getTableGroup() {
            return this.delegate;
        }

        @Override
        public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression) {
            if (tableExpression.equals(this.normalTableExpression)) {
                tableExpression = this.auditTableExpression;
            }
            return super.resolveTableReference(navigablePath, tableExpression);
        }

        @Override
        public TableReference resolveTableReference(NavigablePath navigablePath, ValuedModelPart modelPart, String tableExpression) {
            if (tableExpression.equals(this.normalTableExpression)) {
                return this.resolveTableReference(navigablePath, modelPart, this.auditTableExpression);
            }
            return super.resolveTableReference(navigablePath, modelPart, tableExpression);
        }

        @Override
        public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean resolve) {
            if (tableExpression.equals(this.normalTableExpression)) {
                tableExpression = this.auditTableExpression;
            }
            return super.getTableReference(navigablePath, tableExpression, resolve);
        }

        @Override
        public TableReference getTableReference(NavigablePath navigablePath, ValuedModelPart modelPart, String tableExpression, boolean resolve) {
            if (tableExpression.equals(this.normalTableExpression)) {
                return this.getTableReference(navigablePath, modelPart, this.auditTableExpression, resolve);
            }
            return super.getTableReference(navigablePath, modelPart, tableExpression, resolve);
        }
    }
}

