/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.AbstractPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.MultiDynamicComponentMapper;
import org.hibernate.envers.internal.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SinglePropertyMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.property.access.spi.Setter;

public class ComponentPropertyMapper
extends AbstractPropertyMapper
implements CompositeMapperBuilder {
    private final PropertyData propertyData;
    private final MultiPropertyMapper delegate;
    private final Class componentClass;
    private final EmbeddableInstantiator embeddableInstantiator;

    public ComponentPropertyMapper(PropertyData propertyData, Class componentClass, EmbeddableInstantiator instantiator) {
        this.propertyData = propertyData;
        this.embeddableInstantiator = instantiator;
        if (Map.class.isAssignableFrom(componentClass)) {
            this.delegate = new MultiDynamicComponentMapper(propertyData);
            this.componentClass = HashMap.class;
        } else {
            this.delegate = new MultiPropertyMapper();
            this.componentClass = componentClass;
        }
    }

    @Override
    public void add(PropertyData propertyData) {
        this.delegate.add(propertyData);
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData, Class componentClass, EmbeddableInstantiator instantiator) {
        return this.delegate.addComponent(propertyData, componentClass, instantiator);
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.delegate.addComposite(propertyData, propertyMapper);
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        return this.delegate.mapToMapFromEntity(session, data, newObj, oldObj);
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        if (this.propertyData.isUsingModifiedFlag()) {
            data.put(this.propertyData.getModifiedFlagPropertyName(), this.delegate.mapToMapFromEntity(session, new HashMap<String, Object>(), newObj, oldObj));
        }
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        if (this.propertyData.isUsingModifiedFlag()) {
            boolean hasModifiedCollection = false;
            for (PropertyData propData : this.delegate.getProperties().keySet()) {
                if (!collectionPropertyName.equals(propData.getName())) continue;
                hasModifiedCollection = true;
                break;
            }
            data.put(this.propertyData.getModifiedFlagPropertyName(), hasModifiedCollection);
        }
    }

    @Override
    public void mapToEntityFromMap(EnversService enversService, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        if (data == null || obj == null) {
            return;
        }
        if (this.propertyData.getBeanName() == null) {
            this.delegate.mapToEntityFromMap(enversService, obj, data, primaryKey, versionsReader, revision);
            return;
        }
        this.doPrivileged(() -> {
            try {
                if (this.isDynamicComponentMap()) {
                    Object subObj = ReflectHelper.getDefaultConstructor(this.componentClass).newInstance(new Object[0]);
                    ((Map)obj).put(this.propertyData.getBeanName(), subObj);
                    this.delegate.mapToEntityFromMap(enversService, subObj, data, primaryKey, versionsReader, revision);
                } else {
                    Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData, enversService.getServiceRegistry());
                    if (this.isAllPropertiesNull(data)) {
                        setter.set(obj, null);
                    } else {
                        Object subObj;
                        if (this.embeddableInstantiator != null) {
                            Object[] values = new Object[this.delegate.properties.size()];
                            int i = 0;
                            for (Map.Entry<PropertyData, PropertyMapper> entry : this.delegate.properties.entrySet()) {
                                values[i] = entry.getValue().mapToEntityFromMap(enversService, data, primaryKey, versionsReader, revision);
                                ++i;
                            }
                            subObj = this.embeddableInstantiator.instantiate(() -> values, versionsReader.getSessionImplementor().getSessionFactory());
                        } else {
                            subObj = ReflectHelper.getDefaultConstructor(this.componentClass).newInstance(new Object[0]);
                            this.delegate.mapToEntityFromMap(enversService, subObj, data, primaryKey, versionsReader, revision);
                        }
                        setter.set(obj, subObj);
                    }
                }
            }
            catch (Exception e) {
                throw new AuditException(e);
            }
            return null;
        });
    }

    @Override
    public Object mapToEntityFromMap(EnversService enversService, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        if (data == null || this.propertyData.getBeanName() == null) {
            return null;
        }
        return this.doPrivileged(() -> {
            try {
                Object subObj;
                if (this.isDynamicComponentMap()) {
                    subObj = ReflectHelper.getDefaultConstructor(this.componentClass).newInstance(new Object[0]);
                    this.delegate.mapToEntityFromMap(enversService, subObj, data, primaryKey, versionsReader, revision);
                } else if (this.isAllPropertiesNull(data)) {
                    subObj = null;
                } else if (this.embeddableInstantiator != null) {
                    Object[] values = new Object[this.delegate.properties.size()];
                    int i = 0;
                    for (Map.Entry<PropertyData, PropertyMapper> entry : this.delegate.properties.entrySet()) {
                        values[i] = entry.getValue().mapToEntityFromMap(enversService, data, primaryKey, versionsReader, revision);
                        ++i;
                    }
                    subObj = this.embeddableInstantiator.instantiate(() -> values, versionsReader.getSessionImplementor().getSessionFactory());
                } else {
                    subObj = ReflectHelper.getDefaultConstructor(this.componentClass).newInstance(new Object[0]);
                    this.delegate.mapToEntityFromMap(enversService, subObj, data, primaryKey, versionsReader, revision);
                }
                return subObj;
            }
            catch (Exception e) {
                throw new AuditException(e);
            }
        });
    }

    private boolean isAllPropertiesNull(Map data) {
        for (Map.Entry<PropertyData, PropertyMapper> property : this.delegate.getProperties().entrySet()) {
            Object value = data.get(property.getKey().getName());
            if (value == null && property.getValue() instanceof SinglePropertyMapper) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Object id) {
        return this.delegate.mapCollectionChanges(session, referencingPropertyName, newColl, oldColl, id);
    }

    @Override
    public Map<PropertyData, PropertyMapper> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public boolean hasPropertiesWithModifiedFlag() {
        return this.delegate.hasPropertiesWithModifiedFlag();
    }
}

