/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractCollectionMapper;
import org.hibernate.envers.internal.entities.mapper.relation.CommonCollectionMapperData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.Initializor;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.MapCollectionInitializor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.persister.collection.CollectionPersister;

public class MapCollectionMapper<T extends Map>
extends AbstractCollectionMapper<T>
implements PropertyMapper {
    protected final MiddleComponentData elementComponentData;
    protected final MiddleComponentData indexComponentData;

    public MapCollectionMapper(Configuration configuration, CommonCollectionMapperData commonCollectionMapperData, Class<? extends T> collectionClass, Class<? extends T> proxyClass, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData, boolean revisionTypeInId) {
        super(configuration, commonCollectionMapperData, collectionClass, proxyClass, false, revisionTypeInId);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected Initializor<T> getInitializor(EnversService enversService, AuditReaderImplementor versionsReader, Object primaryKey, Number revision, boolean removed) {
        return new MapCollectionInitializor(enversService, versionsReader, this.commonCollectionMapperData.getQueryGenerator(), primaryKey, revision, removed, this.collectionClass, this.elementComponentData, this.indexComponentData);
    }

    @Override
    protected Collection getNewCollectionContent(PersistentCollection newCollection) {
        if (newCollection == null) {
            return null;
        }
        return ((Map)((Object)newCollection)).entrySet();
    }

    @Override
    protected Collection getOldCollectionContent(Serializable oldCollection) {
        if (oldCollection == null) {
            return null;
        }
        return ((Map)((Object)oldCollection)).entrySet();
    }

    @Override
    protected void mapToMapFromObject(SessionImplementor session, Map<String, Object> idData, Map<String, Object> data, Object changed) {
        this.elementComponentData.getComponentMapper().mapToMapFromObject(session, idData, data, ((Map.Entry)changed).getValue());
        this.indexComponentData.getComponentMapper().mapToMapFromObject(session, idData, data, ((Map.Entry)changed).getKey());
    }

    @Override
    protected Set<Object> buildCollectionChangeSet(Object eventCollection, Collection collection) {
        HashSet<Object> changeSet = new HashSet<Object>();
        if (eventCollection != null) {
            for (Object entry : collection) {
                Map.Entry element;
                if (entry == null || (element = (Map.Entry)Map.Entry.class.cast(entry)).getValue() == null) continue;
                changeSet.add(entry);
            }
        }
        return changeSet;
    }

    @Override
    protected boolean isSame(CollectionPersister collectionPersister, Object oldObject, Object newObject) {
        Map.Entry oldEntry = (Map.Entry)Map.Entry.class.cast(oldObject);
        Map.Entry newEntry = (Map.Entry)Map.Entry.class.cast(newObject);
        return collectionPersister.getKeyType().isSame(oldEntry.getKey(), newEntry.getKey()) && collectionPersister.getElementType().isSame(oldEntry.getValue(), newEntry.getValue());
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, PersistentCollection newColl, Serializable oldColl, Object id) {
        ArrayList<PersistentCollectionChangeData> collectionChanges = new ArrayList<PersistentCollectionChangeData>();
        CollectionPersister collectionPersister = this.resolveCollectionPersister(session, newColl);
        Collection newCollection = this.getNewCollectionContent(newColl);
        Collection oldCollection = this.getOldCollectionContent(oldColl);
        Set<Object> added = this.buildCollectionChangeSet(newColl, newCollection);
        if (oldColl != null) {
            block0: for (Object oldObject : oldCollection) {
                Iterator<Object> itor = added.iterator();
                while (itor.hasNext()) {
                    Object newObject = itor.next();
                    if (!this.isSame(collectionPersister, oldObject, newObject)) continue;
                    itor.remove();
                    continue block0;
                }
            }
        }
        Set<Object> deleted = this.buildCollectionChangeSet(oldColl, oldCollection);
        if (newColl != null) {
            block2: for (Object newObject : newCollection) {
                Iterator<Object> itor = deleted.iterator();
                while (itor.hasNext()) {
                    Object oldObject = itor.next();
                    if (!this.isSame(collectionPersister, newObject, oldObject)) continue;
                    itor.remove();
                    continue block2;
                }
            }
        }
        this.addCollectionChanges(session, collectionChanges, added, RevisionType.ADD, id);
        this.addCollectionChanges(session, collectionChanges, deleted, RevisionType.DEL, id);
        return collectionChanges;
    }
}

