/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.ToOneDelegateSessionImplementor;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.persister.entity.EntityPersister;

public final class ToOneEntityLoader {
    private ToOneEntityLoader() {
    }

    public static Object loadImmediate(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, boolean removed, EnversService enversService) {
        if (enversService.getEntitiesConfigurations().getNotVersionEntityConfiguration(entityName) == null) {
            return versionsReader.find(entityClass, entityName, entityId, revision, removed);
        }
        return versionsReader.getSessionImplementor().immediateLoad(entityName, entityId);
    }

    public static Object createProxy(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, boolean removed, EnversService enversService) {
        EntityPersister persister = versionsReader.getSessionImplementor().getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
        return persister.createProxy(entityId, new ToOneDelegateSessionImplementor(versionsReader, entityClass, entityId, revision, removed, enversService));
    }

    public static Object createProxyOrLoadImmediate(AuditReaderImplementor versionsReader, Class<?> entityClass, String entityName, Object entityId, Number revision, boolean removed, EnversService enversService) {
        EntityPersister persister = versionsReader.getSessionImplementor().getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
        if (persister.hasProxy()) {
            return ToOneEntityLoader.createProxy(versionsReader, entityClass, entityName, entityId, revision, removed, enversService);
        }
        return ToOneEntityLoader.loadImmediate(versionsReader, entityClass, entityName, entityId, revision, removed, enversService);
    }
}

