/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.lazy.proxy;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.collection.spi.LazyInitializable;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.Initializor;

public abstract class CollectionProxy<U, T extends Collection<U>>
implements Collection<U>,
LazyInitializable,
Serializable {
    private static final long serialVersionUID = 8698249863871832402L;
    private transient Initializor<T> initializor;
    protected T delegate;

    protected CollectionProxy() {
    }

    public CollectionProxy(Initializor<T> initializor) {
        this.initializor = initializor;
    }

    protected void checkInit() {
        if (this.delegate == null) {
            this.delegate = (Collection)this.initializor.initialize();
        }
    }

    @Override
    public final boolean wasInitialized() {
        return this.delegate != null;
    }

    @Override
    public final void forceInitialization() {
        this.checkInit();
    }

    @Override
    public int size() {
        this.checkInit();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkInit();
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.checkInit();
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<U> iterator() {
        this.checkInit();
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        this.checkInit();
        return this.delegate.toArray();
    }

    @Override
    public <V> V[] toArray(V[] a) {
        this.checkInit();
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(U o) {
        this.checkInit();
        return this.delegate.add(o);
    }

    @Override
    public boolean remove(Object o) {
        this.checkInit();
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.checkInit();
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends U> c) {
        this.checkInit();
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkInit();
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkInit();
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.checkInit();
        this.delegate.clear();
    }

    public String toString() {
        this.checkInit();
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object obj) {
        this.checkInit();
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        this.checkInit();
        return this.delegate.hashCode();
    }
}

