/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.id.AbstractCompositeIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.internal.util.StringHelper;

public final class OneAuditEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final String mappedBy;
    private final boolean multipleIdMapperKey;
    private final MiddleIdData referencedIdData;

    public OneAuditEntityQueryGenerator(Configuration configuration, MiddleIdData referencingIdData, String referencedEntityName, MiddleIdData referencedIdData, boolean revisionTypeInId, String mappedBy, boolean mappedByKey, String orderByCollectionRole) {
        super(configuration, configuration.getAuditEntityName(referencedEntityName), referencingIdData, revisionTypeInId, orderByCollectionRole);
        this.mappedBy = mappedBy;
        this.referencedIdData = referencedIdData;
        this.multipleIdMapperKey = referencedIdData.getOriginalMapper() instanceof AbstractCompositeIdMapper && mappedByKey;
    }

    @Override
    protected QueryBuilder buildQueryBuilderCommon(SessionFactoryImplementor sessionFactory) {
        QueryBuilder qb = new QueryBuilder(this.entityName, "e__", sessionFactory);
        qb.addProjection(null, "e__", null, false);
        if (this.multipleIdMapperKey) {
            IdMapper mapper = this.getMultipleIdPrefixedMapper();
            mapper.addNamedIdEqualsToQuery(qb.getRootParameters(), null, this.referencingIdData.getPrefixedMapper(), true);
        } else {
            this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(qb.getRootParameters(), null, true);
        }
        if (!StringHelper.isEmpty(this.orderByCollectionRole)) {
            qb.addOrderFragment("e__", this.orderByCollectionRole);
        }
        return qb;
    }

    @Override
    protected void applyValidPredicates(QueryBuilder qb, Parameters rootParameters, boolean inclusive) {
        String revisionPropertyPath = this.configuration.getRevisionNumberPath();
        this.auditStrategy.addEntityAtRevisionRestriction(this.configuration, qb, rootParameters, revisionPropertyPath, this.configuration.getRevisionEndFieldName(), true, this.referencedIdData, revisionPropertyPath, this.configuration.getOriginalIdPropertyName(), "e__", "e2__", true);
        rootParameters.addWhereWithNamedParam(this.getRevisionTypePath(), true, "!=", "delrevisiontype");
    }

    @Override
    protected void applyValidAndRemovePredicates(QueryBuilder remQb) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        this.applyValidPredicates(remQb, valid, false);
        removed.addWhereWithNamedParam(this.configuration.getRevisionNumberPath(), false, "=", "revision");
        removed.addWhereWithNamedParam(this.getRevisionTypePath(), false, "=", "delrevisiontype");
    }

    private IdMapper getMultipleIdPrefixedMapper() {
        String prefix = this.configuration.getOriginalIdPropertyName() + "." + this.mappedBy + ".";
        return this.referencingIdData.getOriginalMapper().prefixMappedProperties(prefix);
    }
}

