/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.synchronization.work;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.strategy.AuditStrategy;

public abstract class AbstractAuditWorkUnit
implements AuditWorkUnit {
    protected final SessionImplementor sessionImplementor;
    protected final EnversService enversService;
    protected final Object id;
    protected final String entityName;
    protected final AuditStrategy auditStrategy;
    protected final RevisionType revisionType;
    private Object performedData;

    protected AbstractAuditWorkUnit(SessionImplementor sessionImplementor, String entityName, EnversService enversService, Object id, RevisionType revisionType) {
        this.sessionImplementor = sessionImplementor;
        this.enversService = enversService;
        this.id = id;
        this.entityName = entityName;
        this.revisionType = revisionType;
        this.auditStrategy = enversService.getAuditStrategy();
    }

    protected void fillDataWithId(Map<String, Object> data, Object revision) {
        Configuration configuration = this.enversService.getConfig();
        HashMap<String, Object> originalId = new HashMap<String, Object>();
        originalId.put(configuration.getRevisionFieldName(), revision);
        IdMapper idMapper = this.enversService.getEntitiesConfigurations().get(this.getEntityName()).getIdMapper();
        idMapper.mapToMapFromId(this.sessionImplementor, originalId, this.id);
        data.put(configuration.getRevisionTypePropertyName(), (Object)this.revisionType);
        data.put(configuration.getOriginalIdPropertyName(), originalId);
    }

    @Override
    public void perform(Session session, Object revisionData) {
        Map<String, Object> data = this.generateData(revisionData);
        this.auditStrategy.perform(session, this.getEntityName(), this.enversService, this.id, data, revisionData);
        this.setPerformed(data);
    }

    @Override
    public Object getEntityId() {
        return this.id;
    }

    @Override
    public boolean isPerformed() {
        return this.performedData != null;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    protected void setPerformed(Object performedData) {
        this.performedData = performedData;
    }

    @Override
    public void undo(Session session) {
        if (this.isPerformed()) {
            session.delete(this.enversService.getConfig().getAuditEntityName(this.getEntityName()), this.performedData);
            session.flush();
        }
    }

    @Override
    public RevisionType getRevisionType() {
        return this.revisionType;
    }
}

