/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.ComponentDescription;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.entities.RelationType;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.Type;

public abstract class CriteriaTools {
    public static void checkPropertyNotARelation(EnversService enversService, String entityName, String propertyName) throws AuditException {
        if (enversService.getEntitiesConfigurations().get(entityName).isRelation(propertyName)) {
            throw new AuditException("This criterion cannot be used on a property that is a relation to another property.");
        }
    }

    public static RelationDescription getRelatedEntity(EnversService enversService, String entityName, String propertyName) throws AuditException {
        RelationDescription relationDesc = enversService.getEntitiesConfigurations().getRelationDescription(entityName, propertyName);
        if (relationDesc == null) {
            return null;
        }
        if (relationDesc.getRelationType() == RelationType.TO_ONE || relationDesc.getRelationType() == RelationType.TO_MANY_MIDDLE || relationDesc.getRelationType() == RelationType.TO_MANY_NOT_OWNING || relationDesc.getRelationType() == RelationType.TO_MANY_MIDDLE_NOT_OWNING) {
            return relationDesc;
        }
        throw new AuditException(String.format(Locale.ENGLISH, "This type of relation (%s.%s) isn't supported and can't be used in queries.", entityName, propertyName));
    }

    public static ComponentDescription getComponent(EnversService enversService, String entityName, String propertyName) {
        return enversService.getEntitiesConfigurations().getComponentDescription(entityName, propertyName);
    }

    public static String determinePropertyName(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, PropertyNameGetter propertyNameGetter) {
        return CriteriaTools.determinePropertyName(enversService, versionsReader, entityName, propertyNameGetter.get(enversService.getConfig()));
    }

    public static String determinePropertyName(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, String propertyName) {
        SessionFactory sessionFactory = versionsReader.getSessionImplementor().getFactory();
        if ("$$id$$".equals(propertyName)) {
            String identifierPropertyName = sessionFactory.getMappingMetamodel().getEntityDescriptor(entityName).getIdentifierPropertyName();
            propertyName = enversService.getConfig().getOriginalIdPropertyName() + "." + identifierPropertyName;
        } else {
            List<String> identifierPropertyNames = CriteriaTools.identifierPropertyNames((SessionFactoryImplementor)sessionFactory, entityName);
            if (identifierPropertyNames.contains(propertyName)) {
                propertyName = enversService.getConfig().getOriginalIdPropertyName() + "." + (String)propertyName;
            } else if (propertyName != null) {
                for (String identifierPropertyName : identifierPropertyNames) {
                    if (!((String)propertyName).startsWith(identifierPropertyName + ".")) continue;
                    propertyName = enversService.getConfig().getOriginalIdPropertyName() + ((String)propertyName).substring(identifierPropertyName.length());
                    break;
                }
            }
        }
        return propertyName;
    }

    public static String determineComponentPropertyPrefix(EnversService enversService, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, String alias) {
        ComponentDescription componentDescription;
        String componentPrefix = "";
        String entityName = aliasToEntityNameMap.get(alias);
        String owningComponentPropertyName = aliasToComponentPropertyNameMap.get(alias);
        if (owningComponentPropertyName != null && (componentDescription = CriteriaTools.getComponent(enversService, entityName, owningComponentPropertyName)).getType() == ComponentDescription.ComponentType.ONE) {
            componentPrefix = componentDescription.getPropertyName().concat("_");
        }
        return componentPrefix;
    }

    private static List<String> identifierPropertyNames(SessionFactoryImplementor sessionFactory, String entityName) {
        String identifierPropertyName = sessionFactory.getMappingMetamodel().getEntityDescriptor(entityName).getIdentifierPropertyName();
        if (identifierPropertyName != null) {
            return Arrays.asList(identifierPropertyName);
        }
        Type identifierType = sessionFactory.getMappingMetamodel().getEntityDescriptor(entityName).getIdentifierType();
        if (identifierType instanceof EmbeddedComponentType) {
            EmbeddedComponentType embeddedComponentType = (EmbeddedComponentType)identifierType;
            return Arrays.asList(embeddedComponentType.getPropertyNames());
        }
        return Collections.emptyList();
    }
}

