/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.internal.Cascade;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.event.internal.EvictVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EvictEvent;
import org.hibernate.event.spi.EvictEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class DefaultEvictEventListener
implements EvictEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultEvictEventListener.class);

    @Override
    public void onEvict(EvictEvent event) throws HibernateException {
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        Object object = event.getObject();
        if (object == null) {
            throw new NullPointerException("null passed to Session.evict()");
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            Object entity;
            Object id = lazyInitializer.getInternalIdentifier();
            if (id == null) {
                throw new IllegalArgumentException("Could not determine identifier of proxy passed to evict()");
            }
            EntityPersister persister = source.getFactory().getMappingMetamodel().getEntityDescriptor(lazyInitializer.getEntityName());
            EntityKey key = source.generateEntityKey(id, persister);
            persistenceContext.removeProxy(key);
            if (!lazyInitializer.isUninitialized() && (entity = persistenceContext.removeEntity(key)) != null) {
                EntityEntry entry = persistenceContext.removeEntry(entity);
                this.doEvict(entity, key, entry.getPersister(), event.getSession());
            }
            lazyInitializer.unsetSession();
        } else {
            EntityEntry entry = persistenceContext.getEntry(object);
            if (entry != null) {
                this.doEvict(object, entry.getEntityKey(), entry.getPersister(), source);
            } else {
                DefaultEvictEventListener.checkEntity(object, source);
            }
        }
    }

    private static void checkEntity(Object object, EventSource source) {
        String entityName = source.getSession().guessEntityName(object);
        if (entityName != null) {
            try {
                EntityPersister persister = source.getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
                if (persister != null) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Non-entity object instance passed to evict: " + object);
    }

    protected void doEvict(Object object, EntityKey key, EntityPersister persister, EventSource session) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Evicting {0}", (Object)MessageHelper.infoString(persister));
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        if (persister.hasNaturalIdentifier()) {
            persistenceContext.getNaturalIdResolutions().handleEviction(key.getIdentifier(), object, persister);
        }
        if (persister.hasCollections()) {
            new EvictVisitor(session, object).process(object, persister);
        }
        persistenceContext.removeEntity(key);
        persistenceContext.removeEntry(object);
        Cascade.cascade(CascadingActions.EVICT, CascadePoint.AFTER_EVICT, session, persister, object);
    }
}

