/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import java.util.concurrent.TimeUnit;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.NaturalIdResolutions;
import org.hibernate.event.internal.AbstractLockUpgradeEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.ResolveNaturalIdEvent;
import org.hibernate.event.spi.ResolveNaturalIdEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.stat.spi.StatisticsImplementor;

public class DefaultResolveNaturalIdEventListener
extends AbstractLockUpgradeEventListener
implements ResolveNaturalIdEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultResolveNaturalIdEventListener.class);

    @Override
    public void onResolveNaturalId(ResolveNaturalIdEvent event) throws HibernateException {
        event.setEntityId(this.resolveNaturalId(event));
    }

    protected Object resolveNaturalId(ResolveNaturalIdEvent event) {
        Object entityId;
        EntityPersister persister = event.getEntityPersister();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Attempting to resolve: {0}#{1}", (Object)MessageHelper.infoString(persister), (Object)event.getNaturalIdValues());
        }
        if ((entityId = this.resolveFromCache(event)) != null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Resolved object in cache: {0}#{1}", (Object)MessageHelper.infoString(persister), (Object)event.getNaturalIdValues());
            }
            return entityId;
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Object not resolved in any cache: {0}#{1}", (Object)MessageHelper.infoString(persister), (Object)event.getNaturalIdValues());
        }
        return this.loadFromDatasource(event);
    }

    protected Object resolveFromCache(ResolveNaturalIdEvent event) {
        return DefaultResolveNaturalIdEventListener.getNaturalIdResolutions(event).findCachedIdByNaturalId(event.getOrderedNaturalIdValues(), event.getEntityPersister());
    }

    protected Object loadFromDatasource(ResolveNaturalIdEvent event) {
        EventSource session = event.getSession();
        EntityPersister entityPersister = event.getEntityPersister();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        boolean statisticsEnabled = statistics.isStatisticsEnabled();
        long startTime = statisticsEnabled ? System.nanoTime() : 0L;
        Object pk = entityPersister.loadEntityIdByNaturalId(event.getOrderedNaturalIdValues(), event.getLockOptions(), session);
        if (statisticsEnabled) {
            long endTime = System.nanoTime();
            long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            statistics.naturalIdQueryExecuted(entityPersister.getRootEntityName(), milliseconds);
        }
        if (pk != null) {
            DefaultResolveNaturalIdEventListener.getNaturalIdResolutions(event).cacheResolutionFromLoad(pk, event.getOrderedNaturalIdValues(), entityPersister);
        }
        return pk;
    }

    private static NaturalIdResolutions getNaturalIdResolutions(ResolveNaturalIdEvent event) {
        return event.getSession().getPersistenceContextInternal().getNaturalIdResolutions();
    }
}

