/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

@Deprecated(since="6", forRemoval=true)
public class ForeignGenerator
implements IdentifierGenerator,
StandardGenerator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ForeignGenerator.class);
    public static final String PROPERTY = "property";
    private String entityName;
    private String propertyName;

    public String getEntityName() {
        return this.entityName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getRole() {
        return this.getEntityName() + "." + this.getPropertyName();
    }

    @Override
    public void configure(Type type, Properties parameters, ServiceRegistry serviceRegistry) throws MappingException {
        this.propertyName = parameters.getProperty(PROPERTY);
        this.entityName = parameters.getProperty("entity_name");
        if (this.propertyName == null) {
            throw new MappingException("param named \"property\" is required for foreign id generation strategy");
        }
    }

    @Override
    public Object generate(SharedSessionContractImplementor sessionImplementor, Object object) {
        Object id;
        EntityPersister entityDescriptor = sessionImplementor.getFactory().getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(this.entityName);
        Object associatedObject = entityDescriptor.getPropertyValue(object, this.propertyName);
        if (associatedObject == null) {
            throw new IdentifierGenerationException("attempted to assign id from null one-to-one property [" + this.getRole() + "]");
        }
        Type propertyType = entityDescriptor.getPropertyType(this.propertyName);
        EntityType foreignValueSourceType = propertyType.isEntityType() ? (EntityType)propertyType : (EntityType)entityDescriptor.getPropertyType("_identifierMapper." + this.propertyName);
        String associatedEntityName = foreignValueSourceType.getAssociatedEntityName();
        try {
            id = ForeignKeys.getEntityIdentifierIfNotUnsaved(associatedEntityName, associatedObject, sessionImplementor);
        }
        catch (TransientObjectException toe) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("ForeignGenerator detected a transient entity [%s]", (Object)associatedEntityName);
            }
            if (sessionImplementor.isSessionImplementor()) {
                id = sessionImplementor.asSessionImplementor().save(associatedEntityName, associatedObject);
            }
            if (sessionImplementor.isStatelessSession()) {
                id = sessionImplementor.asStatelessSession().insert(associatedEntityName, associatedObject);
            }
            throw new IdentifierGenerationException("sessionImplementor is neither Session nor StatelessSession");
        }
        if (sessionImplementor.isSessionImplementor() && sessionImplementor.asSessionImplementor().contains(this.entityName, object)) {
            return IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR;
        }
        return id;
    }
}

