/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.InitCommand;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.ExportableColumn;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.ImplicitDatabaseObjectNamingStrategy;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerDescriptor;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.StandardNamingStrategy;
import org.hibernate.id.enhanced.StandardOptimizerDescriptor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.IncubationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class TableGenerator
implements PersistentIdentifierGenerator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TableGenerator.class.getName());
    public static final String CONFIG_PREFER_SEGMENT_PER_ENTITY = "prefer_entity_table_as_segment_value";
    public static final String TABLE_PARAM = "table_name";
    public static final String DEF_TABLE = "hibernate_sequences";
    public static final String VALUE_COLUMN_PARAM = "value_column_name";
    public static final String DEF_VALUE_COLUMN = "next_val";
    public static final String SEGMENT_COLUMN_PARAM = "segment_column_name";
    public static final String DEF_SEGMENT_COLUMN = "sequence_name";
    public static final String SEGMENT_VALUE_PARAM = "segment_value";
    public static final String DEF_SEGMENT_VALUE = "default";
    public static final String SEGMENT_LENGTH_PARAM = "segment_value_length";
    public static final int DEF_SEGMENT_LENGTH = 255;
    private boolean storeLastUsedValue;
    private Type identifierType;
    private QualifiedName qualifiedTableName;
    private QualifiedName physicalTableName;
    private String segmentColumnName;
    private String segmentValue;
    private int segmentValueLength;
    private String valueColumnName;
    private int initialValue;
    private int incrementSize;
    private String selectQuery;
    private String insertQuery;
    private String updateQuery;
    private Optimizer optimizer;
    private long accessCount;
    private String contributor;

    public final Type getIdentifierType() {
        return this.identifierType;
    }

    public final String getTableName() {
        return this.qualifiedTableName.render();
    }

    public final String getSegmentColumnName() {
        return this.segmentColumnName;
    }

    public final String getSegmentValue() {
        return this.segmentValue;
    }

    public final int getSegmentValueLength() {
        return this.segmentValueLength;
    }

    public final String getValueColumnName() {
        return this.valueColumnName;
    }

    public final int getInitialValue() {
        return this.initialValue;
    }

    public final int getIncrementSize() {
        return this.incrementSize;
    }

    @Override
    public final Optimizer getOptimizer() {
        return this.optimizer;
    }

    public final long getTableAccessCount() {
        return this.accessCount;
    }

    @Deprecated
    public String[] getAllSqlForTests() {
        return new String[]{this.selectQuery, this.insertQuery, this.updateQuery};
    }

    @Override
    public void configure(Type type, Properties parameters, ServiceRegistry serviceRegistry) throws MappingException {
        this.storeLastUsedValue = serviceRegistry.getService(ConfigurationService.class).getSetting("hibernate.id.generator.stored_last_used", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        this.identifierType = type;
        JdbcEnvironment jdbcEnvironment = serviceRegistry.getService(JdbcEnvironment.class);
        this.qualifiedTableName = this.determineGeneratorTableName(parameters, jdbcEnvironment, serviceRegistry);
        this.segmentColumnName = this.determineSegmentColumnName(parameters, jdbcEnvironment);
        this.valueColumnName = this.determineValueColumnName(parameters, jdbcEnvironment);
        this.segmentValue = this.determineSegmentValue(parameters);
        this.segmentValueLength = this.determineSegmentColumnSize(parameters);
        this.initialValue = this.determineInitialValue(parameters);
        this.incrementSize = this.determineIncrementSize(parameters);
        this.optimizer = OptimizerFactory.buildOptimizer(TableGenerator.determineOptimizationStrategy(parameters, this.incrementSize), this.identifierType.getReturnedClass(), this.incrementSize, ConfigurationHelper.getInt("initial_value", parameters, -1));
        this.contributor = parameters.getProperty("CONTRIBUTOR");
        if (this.contributor == null) {
            this.contributor = "orm";
        }
    }

    private static OptimizerDescriptor determineOptimizationStrategy(Properties parameters, int incrementSize) {
        return StandardOptimizerDescriptor.fromExternalName(ConfigurationHelper.getString("optimizer", (Map)parameters, OptimizerFactory.determineImplicitOptimizerName(incrementSize, parameters)));
    }

    protected QualifiedName determineGeneratorTableName(Properties params, JdbcEnvironment jdbcEnvironment, ServiceRegistry serviceRegistry) {
        String explicitTableName = ConfigurationHelper.getString(TABLE_PARAM, params);
        if (StringHelper.isNotEmpty(explicitTableName)) {
            if (explicitTableName.contains(".")) {
                return QualifiedNameParser.INSTANCE.parse(explicitTableName);
            }
            Identifier catalog = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("catalog", params));
            Identifier schema = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("schema", params));
            return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnvironment.getIdentifierHelper().toIdentifier(explicitTableName));
        }
        StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> {
            String localSetting = ConfigurationHelper.getString("hibernate.id.db_structure_naming_strategy", params);
            if (localSetting != null) {
                IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.id.db_structure_naming_strategy");
            }
            return localSetting;
        };
        supplierArray[1] = () -> {
            ConfigurationService configurationService = serviceRegistry.getService(ConfigurationService.class);
            String globalSetting = ConfigurationHelper.getString("hibernate.id.db_structure_naming_strategy", configurationService.getSettings());
            if (globalSetting != null) {
                IncubationLogger.INCUBATION_LOGGER.incubatingSetting("hibernate.id.db_structure_naming_strategy");
            }
            return globalSetting;
        };
        supplierArray[2] = StandardNamingStrategy.class::getName;
        String namingStrategySetting = (String)NullnessHelper.coalesceSuppliedValues(supplierArray);
        ImplicitDatabaseObjectNamingStrategy namingStrategy = strategySelector.resolveStrategy(ImplicitDatabaseObjectNamingStrategy.class, namingStrategySetting);
        Identifier catalog = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("catalog", params));
        Identifier schema = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString("schema", params));
        return namingStrategy.determineTableName(catalog, schema, params, serviceRegistry);
    }

    protected String determineSegmentColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString(SEGMENT_COLUMN_PARAM, (Map)params, DEF_SEGMENT_COLUMN);
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name).render(jdbcEnvironment.getDialect());
    }

    protected String determineValueColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString(VALUE_COLUMN_PARAM, (Map)params, DEF_VALUE_COLUMN);
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name).render(jdbcEnvironment.getDialect());
    }

    protected String determineSegmentValue(Properties params) {
        String segmentValue = params.getProperty(SEGMENT_VALUE_PARAM);
        if (StringHelper.isEmpty(segmentValue)) {
            segmentValue = this.determineDefaultSegmentValue(params);
        }
        return segmentValue;
    }

    protected String determineDefaultSegmentValue(Properties params) {
        boolean preferSegmentPerEntity = ConfigurationHelper.getBoolean(CONFIG_PREFER_SEGMENT_PER_ENTITY, params);
        String defaultToUse = preferSegmentPerEntity ? params.getProperty("target_table") : DEF_SEGMENT_VALUE;
        LOG.usingDefaultIdGeneratorSegmentValue(this.qualifiedTableName.render(), this.segmentColumnName, defaultToUse);
        return defaultToUse;
    }

    protected int determineSegmentColumnSize(Properties params) {
        return ConfigurationHelper.getInt(SEGMENT_LENGTH_PARAM, params, 255);
    }

    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt("initial_value", params, 1);
    }

    protected int determineIncrementSize(Properties params) {
        return ConfigurationHelper.getInt("increment_size", params, 50);
    }

    protected String buildSelectQuery(String formattedPhysicalTableName, SqlStringGenerationContext context) {
        String alias = "tbl";
        String query = "select " + StringHelper.qualify("tbl", this.valueColumnName) + " from " + formattedPhysicalTableName + " tbl where " + StringHelper.qualify("tbl", this.segmentColumnName) + "=?";
        LockOptions lockOptions = new LockOptions(LockMode.PESSIMISTIC_WRITE);
        lockOptions.setAliasSpecificLockMode("tbl", LockMode.PESSIMISTIC_WRITE);
        Map<String, String[]> updateTargetColumnsMap = Collections.singletonMap("tbl", new String[]{this.valueColumnName});
        return context.getDialect().applyLocksToSql(query, lockOptions, updateTargetColumnsMap);
    }

    protected String buildUpdateQuery(String formattedPhysicalTableName, SqlStringGenerationContext context) {
        return "update " + formattedPhysicalTableName + " set " + this.valueColumnName + "=?  where " + this.valueColumnName + "=? and " + this.segmentColumnName + "=?";
    }

    protected String buildInsertQuery(String formattedPhysicalTableName, SqlStringGenerationContext context) {
        return "insert into " + formattedPhysicalTableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ")  values (?,?)";
    }

    protected InitCommand generateInsertInitCommand(SqlStringGenerationContext context) {
        String renderedTableName = context.format(this.physicalTableName);
        int value = this.initialValue;
        if (this.storeLastUsedValue) {
            value = this.initialValue - 1;
        }
        return new InitCommand("insert into " + renderedTableName + "(" + this.segmentColumnName + ", " + this.valueColumnName + ") values ('" + this.segmentValue + "'," + value + ")");
    }

    private IntegralDataTypeHolder makeValue() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }

    @Override
    public Object generate(final SharedSessionContractImplementor session, Object obj) {
        final SqlStatementLogger statementLogger = session.getFactory().getJdbcServices().getSqlStatementLogger();
        final SessionEventListenerManager statsCollector = session.getEventListenerManager();
        return this.optimizer.generate(new AccessCallback(){

            @Override
            public IntegralDataTypeHolder getNextValue() {
                return session.getTransactionCoordinator().createIsolationDelegate().delegateWork(new AbstractReturningWork<IntegralDataTypeHolder>(){

                    @Override
                    public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                        return TableGenerator.this.nextValue(connection, statementLogger, statsCollector);
                    }
                }, true);
            }

            @Override
            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        });
    }

    private IntegralDataTypeHolder nextValue(Connection connection, SqlStatementLogger logger2, SessionEventListenerManager listener) throws SQLException {
        int rows;
        IntegralDataTypeHolder value = this.makeValue();
        do {
            try (PreparedStatement selectPS = this.prepareStatement(connection, this.selectQuery, logger2, listener);){
                selectPS.setString(1, this.segmentValue);
                ResultSet selectRS = this.executeQuery(selectPS, listener);
                if (!selectRS.next()) {
                    long initializationValue = this.storeLastUsedValue ? (long)(this.initialValue - 1) : (long)this.initialValue;
                    value.initialize(initializationValue);
                    try (PreparedStatement statement = this.prepareStatement(connection, this.insertQuery, logger2, listener);){
                        LOG.tracef("binding parameter [%s] - [%s]", 1, (Object)this.segmentValue);
                        statement.setString(1, this.segmentValue);
                        value.bind(statement, 2);
                        this.executeUpdate(statement, listener);
                    }
                } else {
                    int defaultValue = this.storeLastUsedValue ? 0 : 1;
                    value.initialize(selectRS, defaultValue);
                }
                selectRS.close();
            }
            catch (SQLException e) {
                LOG.unableToReadOrInitHiValue(e);
                throw e;
            }
            try (PreparedStatement statement = this.prepareStatement(connection, this.updateQuery, logger2, listener);){
                IntegralDataTypeHolder updateValue = value.copy();
                if (this.optimizer.applyIncrementSizeToSourceValues()) {
                    updateValue.add(this.incrementSize);
                } else {
                    updateValue.increment();
                }
                updateValue.bind(statement, 1);
                value.bind(statement, 2);
                statement.setString(3, this.segmentValue);
                rows = this.executeUpdate(statement, listener);
            }
            catch (SQLException e) {
                LOG.unableToUpdateQueryHiValue(this.physicalTableName.render(), e);
                throw e;
            }
        } while (rows == 0);
        ++this.accessCount;
        if (this.storeLastUsedValue) {
            return value.increment();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(Connection connection, String sql, SqlStatementLogger logger2, SessionEventListenerManager listener) throws SQLException {
        logger2.logStatement(sql, FormatStyle.BASIC.getFormatter());
        try {
            listener.jdbcPrepareStatementStart();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            return preparedStatement;
        }
        finally {
            listener.jdbcPrepareStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(PreparedStatement ps, SessionEventListenerManager listener) throws SQLException {
        try {
            listener.jdbcExecuteStatementStart();
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            listener.jdbcExecuteStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(PreparedStatement ps, SessionEventListenerManager listener) throws SQLException {
        try {
            listener.jdbcExecuteStatementStart();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
        finally {
            listener.jdbcExecuteStatementEnd();
        }
    }

    @Override
    public void registerExportables(Database database) {
        Namespace namespace = database.locateNamespace(this.qualifiedTableName.getCatalogName(), this.qualifiedTableName.getSchemaName());
        Table table = namespace.locateTable(this.qualifiedTableName.getObjectName());
        if (table == null) {
            table = namespace.createTable(this.qualifiedTableName.getObjectName(), identifier -> new Table(this.contributor, namespace, (Identifier)identifier, false));
            BasicTypeRegistry basicTypeRegistry = database.getTypeConfiguration().getBasicTypeRegistry();
            ExportableColumn segmentColumn = new ExportableColumn(database, table, this.segmentColumnName, basicTypeRegistry.resolve(StandardBasicTypes.STRING), database.getTypeConfiguration().getDdlTypeRegistry().getTypeName(12, Size.length(this.segmentValueLength)));
            segmentColumn.setNullable(false);
            table.addColumn(segmentColumn);
            table.setPrimaryKey(new PrimaryKey(table));
            table.getPrimaryKey().addColumn(segmentColumn);
            ExportableColumn valueColumn = new ExportableColumn(database, table, this.valueColumnName, basicTypeRegistry.resolve(StandardBasicTypes.LONG));
            table.addColumn(valueColumn);
        }
        this.physicalTableName = table.getQualifiedTableName();
        table.addInitCommand(this::generateInsertInitCommand);
    }

    @Override
    public void initialize(SqlStringGenerationContext context) {
        String formattedPhysicalTableName = context.format(this.physicalTableName);
        this.selectQuery = this.buildSelectQuery(formattedPhysicalTableName, context);
        this.updateQuery = this.buildUpdateQuery(formattedPhysicalTableName, context);
        this.insertQuery = this.buildInsertQuery(formattedPhysicalTableName, context);
    }
}

