/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.integrator.internal;

import java.util.LinkedHashSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.boot.beanvalidation.BeanValidationIntegrator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cache.internal.CollectionCacheInvalidator;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.jboss.logging.Logger;

public class IntegratorServiceImpl
implements IntegratorService {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = Logger.getLogger(IntegratorServiceImpl.class.getName());
    private final @UnknownKeyFor @NonNull @Initialized LinkedHashSet<@UnknownKeyFor @NonNull @Initialized Integrator> integrators = new LinkedHashSet();

    private IntegratorServiceImpl() {
    }

    public static @UnknownKeyFor @NonNull @Initialized IntegratorServiceImpl create(@UnknownKeyFor @NonNull @Initialized LinkedHashSet<@UnknownKeyFor @NonNull @Initialized Integrator> providedIntegrators, @UnknownKeyFor @NonNull @Initialized ClassLoaderService classLoaderService) {
        IntegratorServiceImpl instance = new IntegratorServiceImpl();
        instance.addIntegrator(new BeanValidationIntegrator());
        instance.addIntegrator(new CollectionCacheInvalidator());
        for (Integrator integrator : providedIntegrators) {
            instance.addIntegrator(integrator);
        }
        for (Integrator integrator : classLoaderService.loadJavaServices(Integrator.class)) {
            instance.addIntegrator(integrator);
        }
        return instance;
    }

    private void addIntegrator(@UnknownKeyFor @NonNull @Initialized Integrator integrator) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Adding Integrator [%s].", (Object)integrator.getClass().getName());
        }
        this.integrators.add(integrator);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Integrator> getIntegrators() {
        return this.integrators;
    }
}

