/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceUnitTransactionType;

public class PersistenceUnitTransactionTypeHelper {
    private PersistenceUnitTransactionTypeHelper() {
    }

    public static PersistenceUnitTransactionType interpretTransactionType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PersistenceUnitTransactionType) {
            return (PersistenceUnitTransactionType)((Object)value);
        }
        String stringValue = value.toString().trim();
        if (stringValue.isEmpty()) {
            return null;
        }
        if (stringValue.equalsIgnoreCase("JTA")) {
            return PersistenceUnitTransactionType.JTA;
        }
        if (stringValue.equalsIgnoreCase("RESOURCE_LOCAL")) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        throw new PersistenceException("Unknown TransactionType: '" + stringValue + "'");
    }
}

