/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.procedure.internal;

import jakarta.persistence.ParameterMode;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.procedure.spi.FunctionReturnImplementor;
import org.hibernate.procedure.spi.NamedCallableQueryMemento;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.query.BindableType;
import org.hibernate.query.OutputableType;
import org.hibernate.sql.exec.internal.JdbcCallFunctionReturnImpl;
import org.hibernate.sql.exec.internal.JdbcCallParameterExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.spi.JdbcCallFunctionReturn;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class FunctionReturnImpl<T>
implements FunctionReturnImplementor<T> {
    private final ProcedureCallImplementor<T> procedureCall;
    private final int sqlTypeCode;
    private OutputableType<T> ormType;

    public FunctionReturnImpl(ProcedureCallImplementor<T> procedureCall, int sqlTypeCode) {
        this.procedureCall = procedureCall;
        this.sqlTypeCode = sqlTypeCode;
    }

    public FunctionReturnImpl(ProcedureCallImplementor<T> procedureCall, OutputableType<T> ormType) {
        this.procedureCall = procedureCall;
        this.sqlTypeCode = ormType.getJdbcType().getDefaultSqlTypeCode();
        this.ormType = ormType;
    }

    @Override
    public JdbcCallFunctionReturn toJdbcFunctionReturn(SharedSessionContractImplementor persistenceContext) {
        JdbcCallParameterExtractorImpl<T> parameterExtractor;
        OutputableType<T> ormType;
        JdbcCallRefCursorExtractorImpl refCursorExtractor;
        if (this.getJdbcTypeCode() == 2012) {
            refCursorExtractor = new JdbcCallRefCursorExtractorImpl(null, 1);
            ormType = null;
            parameterExtractor = null;
        } else {
            if (this.ormType != null) {
                ormType = this.ormType;
            } else {
                TypeConfiguration typeConfiguration = persistenceContext.getFactory().getTypeConfiguration();
                JdbcType sqlTypeDescriptor = typeConfiguration.getJdbcTypeRegistry().getDescriptor(this.getJdbcTypeCode());
                JavaType javaTypeMapping = sqlTypeDescriptor.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration);
                ormType = typeConfiguration.standardBasicTypeForJavaType(javaTypeMapping.getJavaTypeClass());
            }
            parameterExtractor = new JdbcCallParameterExtractorImpl<T>(this.procedureCall.getProcedureName(), null, 1, ormType);
            refCursorExtractor = null;
        }
        return new JdbcCallFunctionReturnImpl(ormType, parameterExtractor, refCursorExtractor);
    }

    @Override
    public int getJdbcTypeCode() {
        return this.sqlTypeCode;
    }

    @Override
    public BindableType<T> getHibernateType() {
        return this.ormType;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public Integer getPosition() {
        return 1;
    }

    @Override
    public ParameterMode getMode() {
        return ParameterMode.OUT;
    }

    @Override
    public Class getParameterType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disallowMultiValuedBinding() {
    }

    @Override
    public void applyAnticipatedType(BindableType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean allowsMultiValuedBinding() {
        return false;
    }

    @Override
    public NamedCallableQueryMemento.ParameterMemento toMemento() {
        return session -> {
            if (this.ormType != null) {
                return new FunctionReturnImpl<T>(this.procedureCall, this.ormType);
            }
            return new FunctionReturnImpl<T>(this.procedureCall, this.sqlTypeCode);
        };
    }
}

