/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.lang.reflect.Field;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.internal.DomainPathPart;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;

public class BasicDotIdentifierConsumer
implements DotIdentifierConsumer {
    private final SqmCreationState creationState;
    private StringBuilder pathSoFar = new StringBuilder();
    private SemanticPathPart currentPart;

    public BasicDotIdentifierConsumer(SqmCreationState creationState) {
        this.creationState = creationState;
    }

    public BasicDotIdentifierConsumer(SemanticPathPart initialState, SqmCreationState creationState) {
        this.currentPart = initialState;
        this.creationState = creationState;
    }

    protected SqmCreationState getCreationState() {
        return this.creationState;
    }

    @Override
    public SemanticPathPart getConsumedPart() {
        return this.currentPart;
    }

    @Override
    public void consumeIdentifier(String identifier, boolean isBase, boolean isTerminal) {
        if (isBase) {
            this.reset();
        }
        if (this.pathSoFar.length() != 0) {
            this.pathSoFar.append('.');
        }
        this.pathSoFar.append(identifier);
        HqlLogging.QUERY_LOGGER.tracef("BasicDotIdentifierHandler#consumeIdentifier( %s, %s, %s ) - %s", identifier, isBase, isTerminal, this.pathSoFar);
        this.currentPart = this.currentPart.resolvePathPart(identifier, isTerminal, this.creationState);
    }

    @Override
    public void consumeTreat(String entityName, boolean isTerminal) {
        EntityDomainType entityDomainType = this.creationState.getCreationContext().getJpaMetamodel().entity(entityName);
        this.currentPart = ((SqmPath)this.currentPart).treatAs(entityDomainType);
    }

    protected void reset() {
        this.pathSoFar.setLength(0);
        this.currentPart = this.createBasePart();
    }

    protected SemanticPathPart createBasePart() {
        return new BaseLocalSequencePart();
    }

    public class BaseLocalSequencePart
    implements SemanticPathPart {
        private boolean isBase = true;

        @Override
        public SemanticPathPart resolvePathPart(String identifier, boolean isTerminal, SqmCreationState creationState) {
            String path;
            block15: {
                EntityDomainType entityDomainType;
                HqlLogging.QUERY_LOGGER.tracef("BaseLocalSequencePart#consumeIdentifier( %s, %s, %s ) - %s", identifier, this.isBase, isTerminal, BasicDotIdentifierConsumer.this.pathSoFar);
                if (this.isBase) {
                    this.isBase = false;
                    SqmPathRegistry sqmPathRegistry = creationState.getProcessingStateStack().getCurrent().getPathRegistry();
                    Object pathRootByAlias = sqmPathRegistry.findFromByAlias(identifier, true);
                    if (pathRootByAlias != null) {
                        this.validateAsRoot((SqmFrom<?, ?>)pathRootByAlias);
                        if (isTerminal) {
                            return pathRootByAlias;
                        }
                        return new DomainPathPart((SqmPath<?>)pathRootByAlias);
                    }
                    Object pathRootByExposedNavigable = sqmPathRegistry.findFromExposing(identifier);
                    if (pathRootByExposedNavigable != null) {
                        this.validateAsRoot((SqmFrom<?, ?>)pathRootByExposedNavigable);
                        JpaPath sqmPath = pathRootByExposedNavigable.get(identifier);
                        if (isTerminal) {
                            return sqmPath;
                        }
                        return new DomainPathPart((SqmPath<?>)sqmPath);
                    }
                }
                SqmCreationContext creationContext = creationState.getCreationContext();
                if (!isTerminal) {
                    return this;
                }
                path = BasicDotIdentifierConsumer.this.pathSoFar.toString();
                String importableName = creationContext.getJpaMetamodel().qualifyImportableName(path);
                if (importableName != null && (entityDomainType = creationContext.getJpaMetamodel().entity(importableName)) != null) {
                    return new SqmLiteralEntityType(entityDomainType, creationContext.getNodeBuilder());
                }
                SqmFunctionDescriptor functionDescriptor = creationContext.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(path);
                if (functionDescriptor != null) {
                    return functionDescriptor.generateSqmExpression(null, creationContext.getQueryEngine());
                }
                int splitPosition = path.lastIndexOf(46);
                if (splitPosition > 0) {
                    String prefix = path.substring(0, splitPosition);
                    String terminal = path.substring(splitPosition + 1);
                    try {
                        Class namedClass = creationContext.getServiceRegistry().getService(ClassLoaderService.class).classForName(prefix);
                        if (namedClass == null) break block15;
                        JavaTypeRegistry javaTypeRegistry = creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeRegistry();
                        if (namedClass.isEnum()) {
                            return new SqmEnumLiteral(Enum.valueOf(namedClass, terminal), (EnumJavaType)javaTypeRegistry.resolveDescriptor(namedClass), terminal, creationContext.getNodeBuilder());
                        }
                        try {
                            Field referencedField = namedClass.getDeclaredField(terminal);
                            if (referencedField != null) {
                                JavaType fieldJtd = javaTypeRegistry.getDescriptor(referencedField.getType());
                                return new SqmFieldLiteral(referencedField, fieldJtd, creationContext.getNodeBuilder());
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            throw new SemanticException(String.format("Could not interpret path expression '%s'", path));
        }

        protected void validateAsRoot(SqmFrom<?, ?> pathRoot) {
        }

        @Override
        public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState processingState) {
            return BasicDotIdentifierConsumer.this.currentPart.resolveIndexedAccess(selector, isTerminal, processingState);
        }
    }
}

