/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.metamodel.EntityType;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.TupleType;
import org.hibernate.metamodel.model.domain.internal.DiscriminatorSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class TypecheckUtil {
    public static boolean areTypesComparable(SqmExpressible<?> lhsType, SqmExpressible<?> rhsType, SessionFactoryImplementor factory) {
        if (lhsType == null || rhsType == null || lhsType == rhsType) {
            return true;
        }
        if (lhsType instanceof SqmCriteriaNodeBuilder.MultiValueParameterType || rhsType instanceof SqmCriteriaNodeBuilder.MultiValueParameterType) {
            return true;
        }
        if (lhsType instanceof EmbeddedSqmPathSource && rhsType instanceof EmbeddedSqmPathSource) {
            return TypecheckUtil.areEmbeddableTypesComparable((EmbeddedSqmPathSource)lhsType, (EmbeddedSqmPathSource)rhsType);
        }
        if (lhsType instanceof TupleType && rhsType instanceof TupleType) {
            return TypecheckUtil.areTupleTypesComparable(factory, (TupleType)lhsType, (TupleType)rhsType);
        }
        if (lhsType instanceof EmbeddedSqmPathSource && rhsType instanceof TupleType || rhsType instanceof EmbeddedSqmPathSource && lhsType instanceof TupleType) {
            return true;
        }
        if (lhsType instanceof EntityType && rhsType instanceof EntityType) {
            return TypecheckUtil.areEntityTypesComparable((EntityType)((Object)lhsType), (EntityType)((Object)rhsType), factory);
        }
        if (lhsType instanceof DiscriminatorSqmPathSource) {
            return TypecheckUtil.isDiscriminatorTypeComparable((DiscriminatorSqmPathSource)lhsType, rhsType, factory);
        }
        if (rhsType instanceof DiscriminatorSqmPathSource) {
            return TypecheckUtil.isDiscriminatorTypeComparable((DiscriminatorSqmPathSource)rhsType, lhsType, factory);
        }
        DomainType<?> lhsDomainType = lhsType.getSqmType();
        DomainType<?> rhsDomainType = rhsType.getSqmType();
        if (lhsDomainType instanceof JdbcMapping && rhsDomainType instanceof JdbcMapping) {
            JdbcType lhsJdbcType = ((JdbcMapping)((Object)lhsDomainType)).getJdbcType();
            JdbcType rhsJdbcType = ((JdbcMapping)((Object)rhsDomainType)).getJdbcType();
            if (lhsJdbcType.getJdbcTypeCode() == rhsJdbcType.getJdbcTypeCode() || lhsJdbcType.isStringLike() && rhsJdbcType.isStringLike() || lhsJdbcType.isTemporal() && rhsJdbcType.isTemporal() || lhsJdbcType.isNumber() && rhsJdbcType.isNumber()) {
                return true;
            }
        }
        return TypecheckUtil.isSameJavaType(lhsType, rhsType);
    }

    private static boolean areEmbeddableTypesComparable(EmbeddedSqmPathSource<?> lhsType, EmbeddedSqmPathSource<?> rhsType) {
        return rhsType.getNodeJavaType() == lhsType.getNodeJavaType();
    }

    private static boolean areTupleTypesComparable(SessionFactoryImplementor factory, TupleType<?> lhsTuple, TupleType<?> rhsTuple) {
        if (rhsTuple.componentCount() != lhsTuple.componentCount()) {
            return false;
        }
        for (int i = 0; i < lhsTuple.componentCount(); ++i) {
            if (TypecheckUtil.areTypesComparable(lhsTuple.get(i), rhsTuple.get(i), factory)) continue;
            return false;
        }
        return true;
    }

    private static boolean areEntityTypesComparable(EntityType<?> lhsType, EntityType<?> rhsType, SessionFactoryImplementor factory) {
        EntityPersister lhsEntity = TypecheckUtil.getEntityDescriptor(factory, lhsType.getName());
        EntityPersister rhsEntity = TypecheckUtil.getEntityDescriptor(factory, rhsType.getName());
        return lhsEntity.getRootEntityName().equals(rhsEntity.getRootEntityName());
    }

    private static boolean isDiscriminatorTypeComparable(DiscriminatorSqmPathSource<?> lhsDiscriminator, SqmExpressible<?> rhsType, SessionFactoryImplementor factory) {
        String entityName = lhsDiscriminator.getEntityDomainType().getHibernateEntityName();
        EntityPersister lhsEntity = factory.getMappingMetamodel().getEntityDescriptor(entityName);
        if (rhsType instanceof EntityType) {
            String rhsEntityName = ((EntityType)((Object)rhsType)).getName();
            EntityPersister rhsEntity = TypecheckUtil.getEntityDescriptor(factory, rhsEntityName);
            return lhsEntity.getRootEntityName().equals(rhsEntity.getRootEntityName());
        }
        if (rhsType instanceof DiscriminatorSqmPathSource) {
            DiscriminatorSqmPathSource discriminator = (DiscriminatorSqmPathSource)rhsType;
            String rhsEntityName = discriminator.getEntityDomainType().getHibernateEntityName();
            EntityPersister rhsEntity = factory.getMappingMetamodel().getEntityDescriptor(rhsEntityName);
            return rhsEntity.getRootEntityName().equals(lhsEntity.getRootEntityName());
        }
        BasicType discriminatorType = (BasicType)lhsDiscriminator.getEntityMapping().getDiscriminatorMapping().getMappedType();
        return TypecheckUtil.areTypesComparable(discriminatorType, rhsType, factory);
    }

    private static boolean isTypeAssignable(SqmPathSource<?> targetType, SqmExpressible<?> expressionType, SessionFactoryImplementor factory) {
        if (targetType == null || expressionType == null || targetType == expressionType) {
            return true;
        }
        if (targetType instanceof EntityType && expressionType instanceof EntityType) {
            return TypecheckUtil.isEntityTypeAssignable((EntityType)((Object)targetType), (EntityType)((Object)expressionType), factory);
        }
        DomainType<?> lhsDomainType = targetType.getSqmType();
        DomainType<?> rhsDomainType = expressionType.getSqmType();
        if (lhsDomainType instanceof JdbcMapping && rhsDomainType instanceof JdbcMapping) {
            JdbcType lhsJdbcType = ((JdbcMapping)((Object)lhsDomainType)).getJdbcType();
            JdbcType rhsJdbcType = ((JdbcMapping)((Object)rhsDomainType)).getJdbcType();
            if (lhsJdbcType.getJdbcTypeCode() == rhsJdbcType.getJdbcTypeCode() || lhsJdbcType.isStringLike() && rhsJdbcType.isStringLike() || lhsJdbcType.isInteger() && rhsJdbcType.isInteger() || lhsJdbcType.isFloat() && rhsJdbcType.isNumber() || lhsJdbcType.isDecimal() && rhsJdbcType.isNumber()) {
                return true;
            }
        }
        return TypecheckUtil.isSameJavaType(targetType, expressionType);
    }

    private static boolean isSameJavaType(SqmExpressible<?> leftType, SqmExpressible<?> rightType) {
        return JavaTypeHelper.isUnknown(leftType.getExpressibleJavaType()) || JavaTypeHelper.isUnknown(rightType.getExpressibleJavaType()) || leftType.getRelationalJavaType() == rightType.getRelationalJavaType() || leftType.getExpressibleJavaType() == rightType.getExpressibleJavaType() || leftType.getBindableJavaType() == rightType.getBindableJavaType();
    }

    private static boolean isEntityTypeAssignable(EntityType<?> lhsType, EntityType<?> rhsType, SessionFactoryImplementor factory) {
        EntityPersister lhsEntity = TypecheckUtil.getEntityDescriptor(factory, lhsType.getName());
        EntityPersister rhsEntity = TypecheckUtil.getEntityDescriptor(factory, rhsType.getName());
        return lhsEntity.isSubclassEntityName(rhsEntity.getEntityName());
    }

    private static EntityPersister getEntityDescriptor(SessionFactoryImplementor factory, String name) {
        return factory.getMappingMetamodel().getEntityDescriptor(factory.getJpaMetamodel().qualifyImportableName(name));
    }

    public static void assertComparable(Expression<?> x, Expression<?> y, SessionFactoryImplementor factory) {
        SqmExpressible rightType;
        SqmExpressible leftType;
        SqmExpression left = (SqmExpression)x;
        SqmExpression right = (SqmExpression)y;
        if (left.getTupleLength() != null && right.getTupleLength() != null && left.getTupleLength().intValue() != right.getTupleLength().intValue()) {
            throw new SemanticException("Cannot compare tuples of different lengths");
        }
        if (left instanceof SqmPluralValuedSimplePath || right instanceof SqmPluralValuedSimplePath) {
            throw new SemanticException("Multi valued paths are only allowed for the member of operator");
        }
        if (!(left instanceof SqmLiteralNull || right instanceof SqmLiteralNull || TypecheckUtil.areTypesComparable(leftType = left.getNodeType(), rightType = right.getNodeType(), factory))) {
            throw new SemanticException(String.format("Cannot compare left expression of type '%s' with right expression of type '%s'", leftType.getTypeName(), rightType.getTypeName()));
        }
    }

    public static void assertAssignable(String hqlString, SqmPath<?> targetPath, SqmTypedNode<?> expression, SessionFactoryImplementor factory) {
        SqmExpressible<?> expressionType;
        SqmExpressible targetType;
        if (!(expression instanceof SqmLiteralNull) && !TypecheckUtil.isTypeAssignable(targetType = targetPath.getNodeType(), expressionType = expression.getNodeType(), factory)) {
            throw new SemanticException(String.format("Cannot assign expression of type '%s' to target path '%s' of type '%s'", expressionType.getTypeName(), targetPath.toHqlString(), targetType.getTypeName()), hqlString, null);
        }
    }

    public static void assertOperable(SqmExpression<?> left, SqmExpression<?> right, BinaryArithmeticOperator op) {
        block15: {
            SqmExpressible<?> leftNodeType;
            block18: {
                Class<?> rightJavaType;
                Class<?> leftJavaType;
                SqmExpressible<?> rightNodeType;
                block17: {
                    block16: {
                        leftNodeType = left.getNodeType();
                        rightNodeType = right.getNodeType();
                        if (leftNodeType == null || rightNodeType == null) break block15;
                        leftJavaType = leftNodeType.getExpressibleJavaType().getJavaTypeClass();
                        rightJavaType = rightNodeType.getExpressibleJavaType().getJavaTypeClass();
                        if (!Number.class.isAssignableFrom(leftJavaType)) break block16;
                        switch (op) {
                            case MULTIPLY: {
                                if (!Number.class.isAssignableFrom(rightJavaType) && !TemporalAmount.class.isAssignableFrom(rightJavaType)) {
                                    throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number' or 'java.time.TemporalAmount')");
                                }
                                break block15;
                            }
                            default: {
                                if (!Number.class.isAssignableFrom(rightJavaType)) {
                                    throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number')");
                                }
                                break block15;
                            }
                        }
                    }
                    if (!TemporalAmount.class.isAssignableFrom(leftJavaType)) break block17;
                    switch (op) {
                        case ADD: 
                        case SUBTRACT: {
                            if (!TemporalAmount.class.isAssignableFrom(rightJavaType)) {
                                throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a temporal amount (it is not an instance of 'java.time.TemporalAmount')");
                            }
                            break block15;
                        }
                        default: {
                            throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + leftNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number')");
                        }
                    }
                }
                if (!Temporal.class.isAssignableFrom(leftJavaType) && !Date.class.isAssignableFrom(leftJavaType)) break block18;
                switch (op) {
                    case ADD: {
                        if (!TemporalAmount.class.isAssignableFrom(rightJavaType)) {
                            throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a temporal amount (it is not an instance of 'java.time.TemporalAmount')");
                        }
                        break block15;
                    }
                    case SUBTRACT: {
                        if (!(Temporal.class.isAssignableFrom(rightJavaType) || Date.class.isAssignableFrom(rightJavaType) || TemporalAmount.class.isAssignableFrom(rightJavaType))) {
                            throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a temporal amount (it is not an instance of 'java.time.TemporalAmount')");
                        }
                        break block15;
                    }
                    default: {
                        throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + leftNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number')");
                    }
                }
            }
            throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + leftNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number', 'java.time.Temporal', or 'java.time.TemporalAmount')");
        }
    }

    public static void assertString(SqmExpression<?> expression) {
        Class<?> javaType;
        SqmExpressible<?> nodeType = expression.getNodeType();
        if (nodeType != null && (javaType = nodeType.getExpressibleJavaType().getJavaTypeClass()) != String.class && javaType != char[].class) {
            throw new SemanticException("Operand of 'like' is of type '" + nodeType.getTypeName() + "' which is not a string (it is not an instance of 'java.lang.String' or 'char[]')");
        }
    }

    public static void assertDuration(SqmExpression<?> expression) {
        Class<?> javaType;
        SqmExpressible<?> nodeType = expression.getNodeType();
        if (nodeType != null && !TemporalAmount.class.isAssignableFrom(javaType = nodeType.getExpressibleJavaType().getJavaTypeClass())) {
            throw new SemanticException("Operand of 'by' is of type '" + nodeType.getTypeName() + "' which is not a duration (it is not an instance of 'java.time.TemporalAmount')");
        }
    }

    public static void assertNumeric(SqmExpression<?> expression, UnaryArithmeticOperator op) {
        Class<?> javaType;
        SqmExpressible<?> nodeType = expression.getNodeType();
        if (nodeType != null && !Number.class.isAssignableFrom(javaType = nodeType.getExpressibleJavaType().getJavaTypeClass())) {
            throw new SemanticException("Operand of " + op.getOperatorChar() + " is of type '" + nodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number')");
        }
    }
}

