/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.spi;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.service.Service;
import org.hibernate.service.spi.ServiceInitiator;
import org.jboss.logging.Logger;

public final class ServiceBinding<@UnknownKeyFor R extends @UnknownKeyFor @NonNull @Initialized Service> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = Logger.getLogger(ServiceBinding.class);
    private final @UnknownKeyFor @NonNull @Initialized ServiceLifecycleOwner lifecycleOwner;
    private final @UnknownKeyFor @NonNull @Initialized Class<R> serviceRole;
    private final @Nullable @UnknownKeyFor @Initialized ServiceInitiator<R> serviceInitiator;
    private volatile R service;

    public ServiceBinding(@UnknownKeyFor @NonNull @Initialized ServiceLifecycleOwner lifecycleOwner, @UnknownKeyFor @NonNull @Initialized Class<R> serviceRole, R service) {
        this.lifecycleOwner = lifecycleOwner;
        this.serviceRole = serviceRole;
        this.serviceInitiator = null;
        this.service = service;
    }

    public ServiceBinding(@UnknownKeyFor @NonNull @Initialized ServiceLifecycleOwner lifecycleOwner, @UnknownKeyFor @NonNull @Initialized ServiceInitiator<R> serviceInitiator) {
        this.lifecycleOwner = lifecycleOwner;
        this.serviceRole = serviceInitiator.getServiceInitiated();
        this.serviceInitiator = serviceInitiator;
    }

    public @UnknownKeyFor @NonNull @Initialized ServiceLifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    public @UnknownKeyFor @NonNull @Initialized Class<R> getServiceRole() {
        return this.serviceRole;
    }

    public @Nullable @UnknownKeyFor @Initialized ServiceInitiator<R> getServiceInitiator() {
        return this.serviceInitiator;
    }

    public R getService() {
        return this.service;
    }

    public void setService(R service) {
        if (this.service != null && log.isDebugEnabled()) {
            log.debug("Overriding existing service binding [" + this.serviceRole.getName() + "]");
        }
        this.service = service;
    }

    public static interface ServiceLifecycleOwner {
        public <R extends Service> R initiateService(@UnknownKeyFor @NonNull @Initialized ServiceInitiator<R> var1);

        public <R extends Service> void configureService(@UnknownKeyFor @NonNull @Initialized ServiceBinding<R> var1);

        public <R extends Service> void injectDependencies(@UnknownKeyFor @NonNull @Initialized ServiceBinding<R> var1);

        public <R extends Service> void startService(@UnknownKeyFor @NonNull @Initialized ServiceBinding<R> var1);

        public <R extends Service> void stopService(@UnknownKeyFor @NonNull @Initialized ServiceBinding<R> var1);
    }
}

