/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.hibernate.customfactory.CustomMetadataFactory;
import liquibase.ext.hibernate.database.HibernateGenericDialect;
import liquibase.ext.hibernate.database.connection.HibernateConnection;
import liquibase.ext.hibernate.database.connection.HibernateDriver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyComponentPathImpl;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyHbmImpl;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyJpaImpl;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;

public abstract class HibernateDatabase
extends AbstractJdbcDatabase {
    private Metadata metadata;
    protected Dialect dialect;
    private boolean indexesForForeignKeys = false;
    public static final String DEFAULT_SCHEMA = "HIBERNATE";
    public static final String HIBERNATE_TEMP_USE_JDBC_METADATA_DEFAULTS = "hibernate.temp.use_jdbc_metadata_defaults";

    public HibernateDatabase() {
        this.setDefaultCatalogName(DEFAULT_SCHEMA);
        this.setDefaultSchemaName(DEFAULT_SCHEMA);
    }

    public boolean requiresPassword() {
        return false;
    }

    public boolean requiresUsername() {
        return false;
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("hibernate")) {
            return HibernateDriver.class.getName();
        }
        return null;
    }

    public int getPriority() {
        return 1;
    }

    public void setConnection(DatabaseConnection conn) {
        super.setConnection(conn);
        try {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Reading hibernate configuration " + this.getConnection().getURL());
            this.metadata = this.buildMetadata();
            this.afterSetup();
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    protected String findDialectName() {
        return this.getHibernateConnection().getProperties().getProperty("hibernate.dialect");
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public Metadata getMetadata() throws DatabaseException {
        return this.metadata;
    }

    protected HibernateConnection getHibernateConnection() {
        return (HibernateConnection)((JdbcConnection)this.getConnection()).getUnderlyingConnection();
    }

    protected final Metadata buildMetadata() throws DatabaseException {
        String path = this.getHibernateConnection().getPath();
        if (!path.contains("/")) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(path);
                if (CustomMetadataFactory.class.isAssignableFrom(clazz)) {
                    try {
                        return ((CustomMetadataFactory)clazz.newInstance()).getMetadata(this, this.getHibernateConnection());
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new DatabaseException((Throwable)e);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.buildMetadataFromPath();
    }

    protected Metadata buildMetadataFromPath() throws DatabaseException {
        MetadataSources sources = this.createMetadataSources();
        this.configureSources(sources);
        MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
        this.configureMetadataBuilder(metadataBuilder);
        AtomicReference thrownException = new AtomicReference();
        AtomicReference result = new AtomicReference();
        Thread t = new Thread(() -> result.set(metadataBuilder.build()));
        t.setContextClassLoader(Scope.getCurrentScope().getClassLoader());
        t.setUncaughtExceptionHandler((_t, e) -> thrownException.set(e));
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e2) {
            throw new DatabaseException((Throwable)e2);
        }
        Throwable thrown = (Throwable)thrownException.get();
        if (thrown != null) {
            throw new DatabaseException(thrown);
        }
        return (Metadata)result.get();
    }

    protected MetadataSources createMetadataSources() throws DatabaseException {
        String dialectString = this.findDialectName();
        if (dialectString != null) {
            try {
                this.dialect = (Dialect)Thread.currentThread().getContextClassLoader().loadClass(dialectString).newInstance();
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using dialect " + dialectString);
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
        } else {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Could not determine hibernate dialect, using HibernateGenericDialect");
            this.dialect = new HibernateGenericDialect();
        }
        StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder().applySetting("hibernate.dialect", (Object)this.dialect).applySetting(HIBERNATE_TEMP_USE_JDBC_METADATA_DEFAULTS, (Object)Boolean.FALSE.toString()).addService(ConnectionProvider.class, (Service)new NoOpConnectionProvider()).addService(MultiTenantConnectionProvider.class, (Service)new NoOpConnectionProvider()).build();
        return new MetadataSources((ServiceRegistry)standardRegistry);
    }

    protected abstract void configureSources(MetadataSources var1) throws DatabaseException;

    protected void configurePhysicalNamingStrategy(String physicalNamingStrategy, MetadataBuilder builder) throws DatabaseException {
        String namingStrategy = this.getHibernateConnection().getProperties().getProperty("hibernate.physical_naming_strategy", physicalNamingStrategy);
        try {
            if (namingStrategy != null) {
                builder.applyPhysicalNamingStrategy((PhysicalNamingStrategy)Thread.currentThread().getContextClassLoader().loadClass(namingStrategy).newInstance());
            }
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected void configureImplicitNamingStrategy(String implicitNamingStrategy, MetadataBuilder builder) throws DatabaseException {
        String namingStrategy = this.getHibernateConnection().getProperties().getProperty("hibernate.implicit_naming_strategy", implicitNamingStrategy);
        try {
            if (namingStrategy != null) {
                switch (namingStrategy) {
                    case "default": 
                    case "jpa": {
                        builder.applyImplicitNamingStrategy(ImplicitNamingStrategyJpaCompliantImpl.INSTANCE);
                        break;
                    }
                    case "legacy-hbm": {
                        builder.applyImplicitNamingStrategy((ImplicitNamingStrategy)ImplicitNamingStrategyLegacyHbmImpl.INSTANCE);
                        break;
                    }
                    case "legacy-jpa": {
                        builder.applyImplicitNamingStrategy((ImplicitNamingStrategy)ImplicitNamingStrategyLegacyJpaImpl.INSTANCE);
                        break;
                    }
                    case "component-path": {
                        builder.applyImplicitNamingStrategy((ImplicitNamingStrategy)ImplicitNamingStrategyComponentPathImpl.INSTANCE);
                        break;
                    }
                    default: {
                        builder.applyImplicitNamingStrategy((ImplicitNamingStrategy)Thread.currentThread().getContextClassLoader().loadClass(namingStrategy).newInstance());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    protected void afterSetup() {
        if (this.dialect instanceof MySQLDialect) {
            this.indexesForForeignKeys = true;
        }
    }

    protected void configureMetadataBuilder(MetadataBuilder metadataBuilder) throws DatabaseException {
        this.configureImplicitNamingStrategy(this.getProperty("hibernate.implicit_naming_strategy"), metadataBuilder);
        this.configurePhysicalNamingStrategy(this.getProperty("hibernate.physical_naming_strategy"), metadataBuilder);
        metadataBuilder.enableGlobalNationalizedCharacterDataSupport(Boolean.parseBoolean(this.getProperty("hibernate.use_nationalized_character_data")));
    }

    public String getProperty(String name) {
        return this.getHibernateConnection().getProperties().getProperty(name);
    }

    public boolean createsIndexesForForeignKeys() {
        return this.indexesForForeignKeys;
    }

    public Integer getDefaultPort() {
        return 0;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    protected String getConnectionCatalogName() throws DatabaseException {
        return this.getDefaultCatalogName();
    }

    protected String getConnectionSchemaName() {
        return this.getDefaultSchemaName();
    }

    public String getDefaultSchemaName() {
        return DEFAULT_SCHEMA;
    }

    public String getDefaultCatalogName() {
        return DEFAULT_SCHEMA;
    }

    public boolean isSafeToRunUpdate() throws DatabaseException {
        return true;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public boolean supportsSchemas() {
        return true;
    }

    public boolean supportsCatalogs() {
        return true;
    }

    static class NoOpConnectionProvider
    implements ConnectionProvider,
    MultiTenantConnectionProvider {
        NoOpConnectionProvider() {
        }

        public Connection getConnection() throws SQLException {
            throw new SQLException("No connection");
        }

        public void closeConnection(Connection conn) throws SQLException {
        }

        public boolean supportsAggressiveRelease() {
            return false;
        }

        public boolean isUnwrappableAs(Class unwrapType) {
            return false;
        }

        public <T> T unwrap(Class<T> unwrapType) {
            return null;
        }

        public Connection getAnyConnection() throws SQLException {
            return this.getConnection();
        }

        public void releaseAnyConnection(Connection connection) throws SQLException {
        }

        public Connection getConnection(String tenantIdentifier) throws SQLException {
            return this.getConnection();
        }

        public void releaseConnection(String tenantIdentifier, Connection connection) throws SQLException {
        }
    }
}

