/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import liquibase.Scope;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.database.connection.HibernateConnection;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class HibernateSpringBeanDatabase
extends HibernateDatabase {
    private BeanDefinition beanDefinition;
    private ManagedProperties beanDefinitionProperties;

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getURL().startsWith("hibernate:spring:");
    }

    @Override
    protected Metadata buildMetadataFromPath() throws DatabaseException {
        this.loadBeanDefinition();
        return super.buildMetadataFromPath();
    }

    @Override
    public String getProperty(String name) {
        String value = super.getProperty(name);
        if (value == null && this.beanDefinitionProperties != null) {
            for (Map.Entry entry : ((ManagedProperties)this.beanDefinition.getPropertyValues().getPropertyValue("hibernateProperties").getValue()).entrySet()) {
                if (!(entry.getKey() instanceof TypedStringValue) || !(entry.getValue() instanceof TypedStringValue) || !((TypedStringValue)entry.getKey()).getValue().equals(name)) continue;
                return ((TypedStringValue)entry.getValue()).getValue();
            }
            value = this.beanDefinitionProperties.getProperty(name);
        }
        return value;
    }

    protected void loadBeanDefinition() throws DatabaseException {
        SimpleBeanDefinitionRegistry registry = new SimpleBeanDefinitionRegistry();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)registry);
        reader.setNamespaceAware(true);
        HibernateConnection connection = this.getHibernateConnection();
        reader.loadBeanDefinitions((Resource)new ClassPathResource(connection.getPath()));
        Properties props = connection.getProperties();
        String beanName = props.getProperty("bean", null);
        if (beanName == null) {
            throw new IllegalStateException("A 'bean' name is required, definition in '" + connection.getPath() + "'.");
        }
        this.beanDefinition = registry.getBeanDefinition(beanName);
        if (this.beanDefinition == null) {
            throw new IllegalStateException("A bean named '" + beanName + "' could not be found in '" + connection.getPath() + "'.");
        }
        this.beanDefinitionProperties = (ManagedProperties)this.beanDefinition.getPropertyValues().getPropertyValue("hibernateProperties").getValue();
    }

    @Override
    protected void configureSources(MetadataSources sources) throws DatabaseException {
        List annotatedClasses;
        MutablePropertyValues properties = this.beanDefinition.getPropertyValues();
        PropertyValue annotatedClassesProperty = properties.getPropertyValue("annotatedClasses");
        if (annotatedClassesProperty != null && (annotatedClasses = (List)annotatedClassesProperty.getValue()) != null) {
            for (TypedStringValue className : annotatedClasses) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Found annotated class " + className.getValue());
                sources.addAnnotatedClass(this.findClass(className.getValue()));
            }
        }
        try {
            List mappingLocations;
            PropertyValue mappingLocationsProp = properties.getPropertyValue("mappingLocations");
            if (mappingLocationsProp != null && (mappingLocations = (List)mappingLocationsProp.getValue()) != null) {
                PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
                for (TypedStringValue mappingLocation : mappingLocations) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Found mappingLocation " + mappingLocation.getValue());
                    Resource[] resources = resourcePatternResolver.getResources(mappingLocation.getValue());
                    for (int i = 0; i < resources.length; ++i) {
                        URL url = resources[i].getURL();
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Adding resource  " + String.valueOf(url));
                        sources.addURL(url);
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof DatabaseException) {
                throw (DatabaseException)e;
            }
            throw new DatabaseException((Throwable)e);
        }
    }

    private Class<?> findClass(String className) {
        return this.findClass(className, Object.class);
    }

    private <T> Class<? extends T> findClass(String className, Class<T> superClass) {
        try {
            Class<?> newClass = Class.forName(className);
            if (superClass.isAssignableFrom(newClass)) {
                return newClass.asSubclass(superClass);
            }
            throw new IllegalStateException("The provided class '" + className + "' is not assignable from the '" + superClass.getName() + "' superclass.");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to find required class: '" + className + "'. Please check classpath and class name.");
        }
    }

    public String getShortName() {
        return "hibernateSpringBean";
    }

    protected String getDefaultDatabaseProductName() {
        return "Hibernate Spring Bean";
    }
}

