/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.UniqueConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;

public class IndexSnapshotGenerator
extends HibernateSnapshotGenerator {
    private static final String HIBERNATE_ORDER_ASC = "asc";
    private static final String HIBERNATE_ORDER_DESC = "desc";

    public IndexSnapshotGenerator() {
        super(liquibase.structure.core.Index.class, new Class[]{liquibase.structure.core.Table.class, ForeignKey.class, UniqueConstraint.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (example.getSnapshotId() != null) {
            return example;
        }
        Relation table = ((liquibase.structure.core.Index)example).getRelation();
        Table hibernateTable = this.findHibernateTable((DatabaseObject)table, snapshot);
        if (hibernateTable == null) {
            return example;
        }
        for (Index hibernateIndex : hibernateTable.getIndexes().values()) {
            liquibase.structure.core.Index index = this.handleHibernateIndex(table, hibernateIndex);
            if (!index.getColumnNames().equalsIgnoreCase(((liquibase.structure.core.Index)example).getColumnNames())) continue;
            Scope.getCurrentScope().getLog(this.getClass()).info("Found index " + index.getName());
            table.getIndexes().add(index);
            return index;
        }
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(liquibase.structure.core.Index.class)) {
            return;
        }
        if (foundObject instanceof liquibase.structure.core.Table) {
            liquibase.structure.core.Table table = (liquibase.structure.core.Table)foundObject;
            Table hibernateTable = this.findHibernateTable((DatabaseObject)table, snapshot);
            if (hibernateTable == null) {
                return;
            }
            for (Index hibernateIndex : hibernateTable.getIndexes().values()) {
                liquibase.structure.core.Index index = this.handleHibernateIndex((Relation)table, hibernateIndex);
                Scope.getCurrentScope().getLog(this.getClass()).info("Found index " + index.getName());
                table.getIndexes().add(index);
            }
        }
    }

    private liquibase.structure.core.Index handleHibernateIndex(Relation table, Index hibernateIndex) {
        liquibase.structure.core.Index index = new liquibase.structure.core.Index();
        index.setRelation(table);
        index.setName(hibernateIndex.getName());
        index.setUnique(this.isUniqueIndex(hibernateIndex));
        for (Column hibernateColumn : hibernateIndex.getColumns()) {
            String hibernateOrder = (String)hibernateIndex.getColumnOrderMap().get(hibernateColumn);
            Boolean descending = HIBERNATE_ORDER_ASC.equals(hibernateOrder) ? Boolean.FALSE : (HIBERNATE_ORDER_DESC.equals(hibernateOrder) ? Boolean.TRUE : null);
            index.getColumns().add(new liquibase.structure.core.Column(hibernateColumn.getName()).setRelation(table).setDescending(descending));
        }
        return index;
    }

    private Boolean isUniqueIndex(Index hibernateIndex) {
        if (hibernateIndex.getColumnSpan() == 1) {
            Column col = (Column)hibernateIndex.getColumns().get(0);
            return col.isUnique();
        }
        return false;
    }

    @Override
    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{liquibase.snapshot.jvm.IndexSnapshotGenerator.class};
    }
}

