/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.mongodb.change.AbstractMongoChange;
import liquibase.ext.mongodb.statement.RunCommandStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="runCommand", description="Provides a helper to run specified database commands. This is the preferred method to issue database commands, as it provides a consistent interface between the shell and drivers. https://docs.mongodb.com/manual/reference/method/db.runCommand/#db-runcommand", priority=1, appliesTo={"database"})
public class RunCommandChange
extends AbstractMongoChange {
    private String command;

    public String getConfirmationMessage() {
        return "Command run";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RunCommandStatement(this.command)};
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }
}

