/*
 * Decompiled with CFR 0.152.
 */
package liquibase.nosql.executor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.AbstractExecutor;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.logging.Logger;
import liquibase.nosql.database.AbstractNoSqlConnection;
import liquibase.nosql.database.AbstractNoSqlDatabase;
import liquibase.nosql.statement.NoSqlExecuteStatement;
import liquibase.nosql.statement.NoSqlQueryForListStatement;
import liquibase.nosql.statement.NoSqlQueryForLongStatement;
import liquibase.nosql.statement.NoSqlQueryForObjectStatement;
import liquibase.nosql.statement.NoSqlUpdateStatement;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;

@LiquibaseService
public class NoSqlExecutor
extends AbstractExecutor {
    public static final String EXECUTOR_NAME = "jdbc";
    private final Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());

    public void setDatabase(Database database) {
        super.setDatabase(database);
    }

    private <T extends AbstractNoSqlDatabase> T getDatabase() {
        return (T)((Object)((AbstractNoSqlDatabase)this.database));
    }

    public String getName() {
        return EXECUTOR_NAME;
    }

    public int getPriority() {
        return 10;
    }

    public boolean supports(Database database) {
        return database instanceof MongoLiquibaseDatabase;
    }

    protected <C extends AbstractNoSqlConnection> C getConnection() {
        return (C)((AbstractNoSqlConnection)Optional.ofNullable(this.database).map(Database::getConnection).orElse(null));
    }

    public <T> T queryForObject(SqlStatement sql, Class<T> requiredType) throws DatabaseException {
        return this.queryForObject(sql, requiredType, Collections.emptyList());
    }

    public <T> T queryForObject(SqlStatement sql, Class<T> requiredType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof NoSqlQueryForObjectStatement) {
            try {
                return ((NoSqlQueryForObjectStatement)sql).queryForObject(this.getDatabase(), requiredType);
            }
            catch (Exception e) {
                throw new DatabaseException("Could not query for object", (Throwable)e);
            }
        }
        throw new IllegalArgumentException();
    }

    public long queryForLong(SqlStatement sql) throws DatabaseException {
        return this.queryForLong(sql, Collections.emptyList());
    }

    public long queryForLong(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof NoSqlQueryForLongStatement) {
            try {
                return ((NoSqlQueryForLongStatement)sql).queryForLong(this.getDatabase());
            }
            catch (Exception e) {
                throw new DatabaseException("Could not query for long", (Throwable)e);
            }
        }
        throw new IllegalArgumentException();
    }

    public int queryForInt(SqlStatement sql) {
        throw new UnsupportedOperationException();
    }

    public int queryForInt(SqlStatement sql, List<SqlVisitor> sqlVisitors) {
        throw new UnsupportedOperationException();
    }

    public List<Object> queryForList(SqlStatement sql, Class elementType) throws DatabaseException {
        return this.queryForList(sql, elementType, Collections.emptyList());
    }

    public List<Object> queryForList(SqlStatement sql, Class elementType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof NoSqlQueryForListStatement) {
            try {
                return ((NoSqlQueryForListStatement)sql).queryForList(this.getDatabase());
            }
            catch (Exception e) {
                throw new DatabaseException("Could not query for list", (Throwable)e);
            }
        }
        throw new IllegalArgumentException();
    }

    public List<Map<String, ?>> queryForList(SqlStatement sql) {
        return this.queryForList(sql, Collections.emptyList());
    }

    public List<Map<String, ?>> queryForList(SqlStatement sql, List<SqlVisitor> sqlVisitors) {
        throw new UnsupportedOperationException();
    }

    public void execute(UpdateStatement updateStatement) throws DatabaseException {
        if (updateStatement.getNewColumnValues().containsKey("MD5SUM") && updateStatement.getNewColumnValues().get("MD5SUM") == null) {
            try {
                ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.getDatabase()).clearAllCheckSums();
            }
            catch (Exception e) {
                throw new DatabaseException("Could not execute", (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void execute(SqlStatement sql) throws DatabaseException {
        this.execute(sql, Collections.emptyList());
    }

    public void execute(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof NoSqlExecuteStatement) {
            try {
                ((NoSqlExecuteStatement)sql).execute(this.getDatabase());
            }
            catch (Exception e) {
                throw new DatabaseException("Could not execute", (Throwable)e);
            }
        } else if (sql instanceof UpdateStatement) {
            this.execute((UpdateStatement)sql);
        } else {
            throw new IllegalArgumentException("Mongodb cannot execute " + sql.getClass().getName() + " statements");
        }
    }

    public int update(SqlStatement sql) throws DatabaseException {
        return this.update(sql, Collections.emptyList());
    }

    public int update(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof NoSqlUpdateStatement) {
            try {
                return ((NoSqlUpdateStatement)sql).update(this.getDatabase());
            }
            catch (Exception e) {
                throw new DatabaseException("Could not execute", (Throwable)e);
            }
        }
        throw new IllegalArgumentException();
    }

    public void comment(String message) {
        this.log.info(message);
    }

    public boolean updatesDatabase() {
        return true;
    }
}

