/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.changelog;

import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.ext.mongodb.changelog.MongoRanChangeSet;
import liquibase.nosql.changelog.AbstractNoSqlItemToDocumentConverter;
import org.bson.Document;

public class MongoRanChangeSetToDocumentConverter
extends AbstractNoSqlItemToDocumentConverter<MongoRanChangeSet, Document> {
    @Override
    public Document toDocument(MongoRanChangeSet item) {
        Document document = new Document();
        document.append("fileName", (Object)item.getChangeLog());
        document.append("id", (Object)item.getId());
        document.append("author", (Object)item.getAuthor());
        document.append("md5sum", Optional.ofNullable(item.getLastCheckSum()).map(CheckSum::toString).orElse(null));
        document.append("dateExecuted", Optional.ofNullable(item.getDateExecuted()).orElse(null));
        document.append("tag", (Object)item.getTag());
        document.append("execType", Optional.ofNullable(item.getExecType()).map(e -> e.value).orElse(null));
        document.append("description", (Object)item.getDescription());
        document.append("comments", (Object)item.getComments());
        document.append("contexts", (Object)this.buildFullContext(item.getContextExpression(), item.getInheritableContexts()));
        document.append("labels", (Object)this.buildLabels(item.getLabels()));
        document.append("deploymentId", (Object)item.getDeploymentId());
        document.append("orderExecuted", (Object)item.getOrderExecuted());
        document.append("liquibase", (Object)item.getLiquibaseVersion());
        return document;
    }

    @Override
    public MongoRanChangeSet fromDocument(Document document) {
        return new MongoRanChangeSet((String)document.get((Object)"fileName"), (String)document.get((Object)"id"), (String)document.get((Object)"author"), CheckSum.parse((String)((String)document.get((Object)"md5sum"))), (Date)document.get((Object)"dateExecuted"), (String)document.get((Object)"tag"), Optional.ofNullable(document.get((Object)"execType")).map(s -> ChangeSet.ExecType.valueOf((String)((String)s))).orElse(null), (String)document.get((Object)"description"), (String)document.get((Object)"comments"), new ContextExpression((String)document.get((Object)"contexts")), null, new Labels((String)document.get((Object)"labels")), (String)document.get((Object)"deploymentId"), Optional.ofNullable(document.get((Object)"orderExecuted")).orElse(null), (String)document.get((Object)"liquibase"));
    }

    @Override
    public String buildLabels(Labels labels) {
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        return labels.toString();
    }

    @Override
    public String buildFullContext(ContextExpression contextExpression, Collection<ContextExpression> inheritableContexts) {
        if (contextExpression == null || contextExpression.isEmpty()) {
            return null;
        }
        StringBuilder contextExpressionString = new StringBuilder();
        boolean notFirstContext = false;
        for (ContextExpression inheritableContext : inheritableContexts) {
            this.appendContext(contextExpressionString, inheritableContext.toString(), notFirstContext);
            notFirstContext = true;
        }
        this.appendContext(contextExpressionString, contextExpression.toString(), notFirstContext);
        return contextExpressionString.toString();
    }

    private void appendContext(StringBuilder contextExpression, String contextToAppend, boolean notFirstContext) {
        boolean complexExpression;
        boolean bl = complexExpression = contextToAppend.contains(",") || contextToAppend.contains(" ");
        if (notFirstContext) {
            contextExpression.append(" AND ");
        }
        if (complexExpression) {
            contextExpression.append("(");
        }
        contextExpression.append(contextToAppend);
        if (complexExpression) {
            contextExpression.append(")");
        }
    }
}

