/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.lockservice;

import java.util.Date;
import java.util.Optional;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.util.NetUtil;

public class MongoChangeLogLock
extends DatabaseChangeLogLock {
    private final Boolean locked;

    public MongoChangeLogLock() {
        this(1, new Date(), "NoArgConstructor", true);
    }

    public MongoChangeLogLock(Integer id, Date lockGranted, String lockedBy, Boolean locked) {
        super(id.intValue(), lockGranted, lockedBy);
        this.locked = locked;
    }

    public String toString() {
        return super.toString();
    }

    public static String formLockedBy() {
        try {
            String HOST_NAME = NetUtil.getLocalHostName();
            String HOST_DESCRIPTION = Optional.ofNullable(System.getProperty("liquibase.hostDescription")).map(v -> "#" + v).orElse("");
            String HOST_ADDRESS = NetUtil.getLocalHostAddress();
            return HOST_NAME + HOST_DESCRIPTION + " (" + HOST_ADDRESS + ")";
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public static class Fields {
        public static final String id = "_id";
        public static final String lockGranted = "lockGranted";
        public static final String lockedBy = "lockedBy";
        public static final String locked = "locked";
    }
}

