/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.database;

import com.mongodb.ConnectionString;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Driver;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.database.MongoClientDriver;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.nosql.database.AbstractNoSqlConnection;
import liquibase.util.StringUtil;

public class MongoConnection
extends AbstractNoSqlConnection {
    public static final int DEFAULT_PORT = 27017;
    public static final String MONGO_PREFIX = "mongodb://";
    public static final String MONGO_DNS_PREFIX = "mongodb+srv://";
    private ConnectionString connectionString;
    protected MongoClient mongoClient;
    protected MongoDatabase mongoDatabase;

    @Override
    public boolean supports(String url) {
        if (url == null) {
            return false;
        }
        return url.toLowerCase().startsWith("mongodb");
    }

    public String getCatalog() throws DatabaseException {
        try {
            return this.mongoDatabase.getName();
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public String getDatabaseProductName() throws DatabaseException {
        return "MongoDB";
    }

    public String getURL() {
        return String.join((CharSequence)",", Optional.ofNullable(this.connectionString).map(ConnectionString::getHosts).orElse(Collections.emptyList()));
    }

    public String getConnectionUserName() {
        return Optional.ofNullable(this.connectionString).map(ConnectionString::getCredential).map(MongoCredential::getUserName).orElse("");
    }

    public boolean isClosed() throws DatabaseException {
        return Objects.isNull(this.mongoClient);
    }

    public void open(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        try {
            String urlWithCredentials = this.injectCredentials(StringUtil.trimToEmpty((String)url), driverProperties);
            this.connectionString = new ConnectionString(urlWithCredentials);
            this.mongoClient = ((MongoClientDriver)driverObject).connect(this.connectionString);
            String database = this.connectionString.getDatabase();
            if (database == null) {
                throw new IllegalArgumentException("Database not specified in URL");
            }
            this.mongoDatabase = this.mongoClient.getDatabase(Objects.requireNonNull(database)).withCodecRegistry(BsonUtils.uuidCodecRegistry());
        }
        catch (Exception e) {
            throw new DatabaseException("Could not open connection to database: " + Optional.ofNullable(this.connectionString).map(ConnectionString::getDatabase).orElse(url), (Throwable)e);
        }
    }

    private String injectCredentials(String url, Properties driverProperties) {
        if (Objects.nonNull(driverProperties)) {
            Optional<String> user = Optional.ofNullable(StringUtil.trimToNull((String)driverProperties.getProperty("user"))).map(MongoConnection::encode);
            Optional<String> password = Optional.ofNullable(StringUtil.trimToNull((String)driverProperties.getProperty("password"))).map(MongoConnection::encode);
            if (user.isPresent()) {
                String mongoPrefix = url.startsWith(MONGO_DNS_PREFIX) ? MONGO_DNS_PREFIX : MONGO_PREFIX;
                return mongoPrefix + user.get() + password.map(p -> ":" + p).orElse("") + "@" + url.substring(mongoPrefix.length());
            }
        }
        return url;
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws DatabaseException {
        try {
            if (!this.isClosed()) {
                this.mongoClient.close();
                this.mongoClient = null;
            }
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public ConnectionString getConnectionString() {
        return this.connectionString;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }

    public void setConnectionString(ConnectionString connectionString) {
        this.connectionString = connectionString;
    }

    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public void setMongoDatabase(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }
}

