/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.database;

import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.database.MongoConnection;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class MongoLiquibaseDatabaseUtil {
    private MongoLiquibaseDatabaseUtil() {
    }

    public static void sendPingSignal(DatabaseConnection connection) throws DatabaseException {
        try {
            if (connection instanceof MongoConnection) {
                MongoClient mongoClient = ((MongoConnection)connection).getMongoClient();
                BsonDocument command = new BsonDocument("ping", (BsonValue)new BsonInt64(1L));
                MongoDatabase adminDb = mongoClient.getDatabase("admin");
                adminDb.runCommand((Bson)command);
            }
        }
        catch (MongoException e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

