/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.lockservice;

import java.util.Optional;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.RunCommandStatement;
import org.bson.Document;
import org.bson.conversions.Bson;

public class AdjustChangeLogLockCollectionStatement
extends RunCommandStatement {
    public static String OPTIONS = "{ collMod: \"%s\",\n\"validator\": {\n     \"$jsonSchema\": {\n         \"bsonType\": \"object\",\n         \"description\": \"Database Lock Collection\",\n         \"required\": [\"_id\", \"locked\"],\n             \"properties\": {\n                 \"_id\": {\n                     \"bsonType\": \"int\",\n                     \"description\": \"Unique lock identifier\"\n                 },\n                 \"locked\": {\n                     \"bsonType\": \"bool\",\n                     \"description\": \"Lock flag\"\n                 },\n                 \"lockGranted\": {\n                     \"bsonType\": \"date\",\n                     \"description\": \"Timestamp when lock acquired\"\n                 },\n                 \"lockedBy\": {\n                     \"bsonType\": [\"string\", \"null\"],\n                     \"description\": \"Owner of the lock\"\n                 }\n             }\n         }\n     },\n\"validationLevel\": \"strict\",\n\"validationAction\": \"error\"\n}";
    public static final String COMMAND_NAME = "adjustChangeLogLockCollection";
    private final String collectionName;

    public AdjustChangeLogLockCollectionStatement(String collectionName) {
        super(String.format(OPTIONS, collectionName));
        this.collectionName = collectionName;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public void execute(MongoLiquibaseDatabase database) {
        if (database.getSupportsValidator().booleanValue()) {
            super.execute(database);
        }
    }

    @Override
    public String toJs() {
        return "db." + this.getCommandName() + "(" + (String)Optional.ofNullable(this.command).map(Document::toJson).orElse(null) + ");";
    }

    @Override
    public Document run(MongoLiquibaseDatabase database) {
        return database.getMongoDatabase().runCommand((Bson)this.command);
    }

    public String getCollectionName() {
        return this.collectionName;
    }
}

