/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.configuration;

import liquibase.configuration.AbstractConfigurationContainer;

public class MongoConfiguration
extends AbstractConfigurationContainer {
    public static final String LIQUIBASE_MONGO_NAMESPACE = "liquibase.mongodb";
    public static final String ADJUST_TRACKING_TABLES_ON_STARTUP = "adjustTrackingTablesOnStartup";
    public static final String SUPPORTS_VALIDATOR = "supportsValidator";

    public MongoConfiguration() {
        this(LIQUIBASE_MONGO_NAMESPACE);
    }

    protected MongoConfiguration(String namespace) {
        super(namespace);
        this.getContainer().addProperty(ADJUST_TRACKING_TABLES_ON_STARTUP, Boolean.class).setDescription("Enabling this property will validate History Change Log and Log Lock Collections on Startup and adjust if are not up to date with current release.Worth keeping it disabled and re-enable when upgraded to a new Liquibase version.").setDefaultValue((Object)Boolean.TRUE);
        this.getContainer().addProperty(SUPPORTS_VALIDATOR, Boolean.class).setDescription("Disabling this property will let create the Tracking Collections without validators.This will permit usage on Mongo Versions not supporting Validators").setDefaultValue((Object)Boolean.TRUE);
    }

    public Boolean getAdjustTrackingTablesOnStartup() {
        return (Boolean)this.getContainer().getValue(ADJUST_TRACKING_TABLES_ON_STARTUP, Boolean.class);
    }

    public MongoConfiguration setAdjustTrackingTablesOnStartup(Boolean value) {
        this.getContainer().setValue(ADJUST_TRACKING_TABLES_ON_STARTUP, (Object)value);
        return this;
    }

    public Boolean getSupportsValidator() {
        return (Boolean)this.getContainer().getValue(SUPPORTS_VALIDATOR, Boolean.class);
    }

    public MongoConfiguration setSupportsValidator(Boolean value) {
        this.getContainer().setValue(SUPPORTS_VALIDATOR, (Object)value);
        return this;
    }
}

