/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.precondition;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.CountCollectionByNameStatement;
import liquibase.precondition.AbstractPrecondition;
import liquibase.precondition.Precondition;
import lombok.Generated;

public class CollectionExistsPrecondition
extends AbstractPrecondition {
    private String collectionName;

    public String getName() {
        return "collectionExists";
    }

    public Warnings warn(Database database) {
        return new Warnings();
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet, ChangeExecListener changeExecListener) throws PreconditionFailedException, PreconditionErrorException {
        try {
            CountCollectionByNameStatement countCollectionByNameStatement = new CountCollectionByNameStatement(this.collectionName);
            if (countCollectionByNameStatement.queryForLong((MongoLiquibaseDatabase)database) == 0L) {
                throw new PreconditionFailedException(String.format("Collection %s does not exist", this.collectionName), changeLog, (Precondition)this);
            }
        }
        catch (PreconditionFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PreconditionErrorException(e, changeLog, (Precondition)this);
        }
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }

    @Generated
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }
}

