/*
 * Decompiled with CFR 0.152.
 */
package liquibase.nosql.changelog;

import java.time.Clock;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import liquibase.Scope;
import liquibase.changelog.AbstractChangeLogHistoryService;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.exception.DatabaseException;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.logging.Logger;
import liquibase.nosql.database.AbstractNoSqlDatabase;
import liquibase.nosql.executor.NoSqlExecutor;
import lombok.Generated;

public abstract class AbstractNoSqlHistoryService<D extends AbstractNoSqlDatabase>
extends AbstractChangeLogHistoryService {
    private List<RanChangeSet> ranChangeSetList;
    private boolean serviceInitialized;
    private static final ResourceBundle mongoBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongo");
    private Boolean hasDatabaseChangeLogTable;
    private Integer lastChangeSetSequenceValue;
    private Boolean adjustedChangeLogTable = Boolean.FALSE;
    private Clock clock = Clock.systemDefaultZone();

    public int getPriority() {
        return 10;
    }

    public String getDatabaseChangeLogTableName() {
        return this.getDatabase().getDatabaseChangeLogTableName();
    }

    public boolean canCreateChangeLogTable() {
        return true;
    }

    public boolean isServiceInitialized() {
        return this.serviceInitialized;
    }

    public D getNoSqlDatabase() {
        return (D)((Object)((AbstractNoSqlDatabase)this.getDatabase()));
    }

    public NoSqlExecutor getExecutor() throws DatabaseException {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.getDatabase());
        if (executor instanceof LoggingExecutor) {
            throw new DatabaseException(String.format(mongoBundle.getString("command.unsupported"), "*sql"));
        }
        return (NoSqlExecutor)executor;
    }

    public void reset() {
        super.reset();
        this.ranChangeSetList = null;
        this.serviceInitialized = false;
        this.hasDatabaseChangeLogTable = null;
        this.adjustedChangeLogTable = Boolean.FALSE;
    }

    public void init() throws DatabaseException {
        if (this.serviceInitialized) {
            return;
        }
        if (!this.hasDatabaseChangeLogTable()) {
            this.getLogger().info("Create Database Change Log Collection");
            this.getLogger().info("Creating database history collection with name: " + this.getDatabase().getConnection().getCatalog() + "." + this.getDatabaseChangeLogTableName());
            this.createRepository();
            this.getLogger().info("Created database history collection : " + this.getDatabase().getConnection().getCatalog() + "." + this.getDatabaseChangeLogTableName());
            this.hasDatabaseChangeLogTable = Boolean.TRUE;
        }
        if (!this.adjustedChangeLogTable.booleanValue()) {
            this.adjustRepository();
            this.adjustedChangeLogTable = Boolean.TRUE;
        }
        this.serviceInitialized = true;
    }

    public boolean hasDatabaseChangeLogTable() {
        if (Objects.isNull(this.hasDatabaseChangeLogTable)) {
            try {
                this.hasDatabaseChangeLogTable = this.existsRepository();
            }
            catch (Exception e) {
                throw new UnexpectedLiquibaseException((Throwable)e);
            }
        }
        return this.hasDatabaseChangeLogTable;
    }

    public List<RanChangeSet> getRanChangeSets() throws DatabaseException {
        if (Objects.isNull(this.ranChangeSetList)) {
            this.ranChangeSetList = this.queryRanChangeSets();
        }
        return Collections.unmodifiableList(this.ranChangeSetList);
    }

    public void replaceChecksum(ChangeSet changeSet) throws DatabaseException {
        this.updateCheckSum(changeSet);
        this.getLogger().info(String.format("Replace checksum executed. ChangeSet: [filename: %s, id: %s, author: %s]", changeSet.getFilePath(), changeSet.getId(), changeSet.getAuthor()));
        this.reset();
    }

    public RanChangeSet getRanChangeSet(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        if (!this.hasDatabaseChangeLogTable()) {
            return null;
        }
        return super.getRanChangeSet(changeSet);
    }

    public void setExecType(ChangeSet changeSet, ChangeSet.ExecType execType) throws DatabaseException {
        Integer nextSequenceValue = this.getNextSequenceValue();
        this.markChangeSetRun(changeSet, execType, nextSequenceValue);
        this.getDatabase().commit();
        if (this.ranChangeSetList != null) {
            this.ranChangeSetList.add(new RanChangeSet(changeSet, execType, null, null));
        }
    }

    public void removeFromHistory(ChangeSet changeSet) throws DatabaseException {
        this.removeRanChangeSet(changeSet);
        if (this.ranChangeSetList != null) {
            this.ranChangeSetList.remove(new RanChangeSet(changeSet));
        }
    }

    public int getNextSequenceValue() throws DatabaseException {
        if (Objects.isNull(this.lastChangeSetSequenceValue)) {
            this.lastChangeSetSequenceValue = Objects.isNull(this.getDatabase().getConnection()) ? Integer.valueOf(0) : this.generateNextSequence();
        }
        Integer n = this.lastChangeSetSequenceValue;
        this.lastChangeSetSequenceValue = this.lastChangeSetSequenceValue + 1;
        return this.lastChangeSetSequenceValue;
    }

    public void tag(String tagString) throws DatabaseException {
        long totalRows = this.countRanChangeSets();
        if (totalRows == 0L) {
            ChangeSet emptyChangeSet = new ChangeSet(String.valueOf(new Date().getTime()), "liquibase", false, false, "liquibase-internal", null, null, this.getDatabase().getObjectQuotingStrategy(), null);
            this.setExecType(emptyChangeSet, ChangeSet.ExecType.EXECUTED);
        }
        this.tagLast(tagString);
        if (this.ranChangeSetList != null) {
            this.ranChangeSetList.get(this.ranChangeSetList.size() - 1).setTag(tagString);
        }
    }

    public boolean tagExists(String tag) throws DatabaseException {
        long count = this.countTags(tag);
        return count > 0L;
    }

    public void clearAllCheckSums() throws DatabaseException {
        this.getLogger().info("Clear all checksums");
        this.clearChekSums();
        this.getLogger().info("Clear all checksums executed");
    }

    public void destroy() {
        try {
            this.getLogger().info("Dropping Collection Database Change Log: " + this.getDatabaseChangeLogTableName());
            if (this.existsRepository().booleanValue()) {
                this.dropRepository();
                this.getLogger().info("Dropped Collection Database Change Log: " + this.getDatabaseChangeLogTableName());
            } else {
                this.getLogger().warning("Cannot Drop Collection Database Change Log as not found: " + this.getDatabaseChangeLogTableName());
            }
            this.reset();
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    protected abstract Logger getLogger();

    protected abstract Boolean existsRepository() throws DatabaseException;

    protected abstract void createRepository() throws DatabaseException;

    protected abstract void adjustRepository() throws DatabaseException;

    protected abstract void dropRepository() throws DatabaseException;

    protected abstract List<RanChangeSet> queryRanChangeSets() throws DatabaseException;

    protected abstract Integer generateNextSequence() throws DatabaseException;

    protected abstract void markChangeSetRun(ChangeSet var1, ChangeSet.ExecType var2, Integer var3) throws DatabaseException;

    protected abstract void removeRanChangeSet(ChangeSet var1) throws DatabaseException;

    protected abstract void clearChekSums() throws DatabaseException;

    protected abstract long countTags(String var1) throws DatabaseException;

    protected abstract void tagLast(String var1) throws DatabaseException;

    protected abstract long countRanChangeSets() throws DatabaseException;

    public abstract void updateCheckSum(ChangeSet var1) throws DatabaseException;

    @Generated
    public List<RanChangeSet> getRanChangeSetList() {
        return this.ranChangeSetList;
    }

    @Generated
    public Boolean getHasDatabaseChangeLogTable() {
        return this.hasDatabaseChangeLogTable;
    }

    @Generated
    public Integer getLastChangeSetSequenceValue() {
        return this.lastChangeSetSequenceValue;
    }

    @Generated
    public Boolean getAdjustedChangeLogTable() {
        return this.adjustedChangeLogTable;
    }

    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    public void setClock(Clock clock) {
        this.clock = clock;
    }
}

