/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.change;

import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.mongodb.change.AbstractMongoChange;
import liquibase.ext.mongodb.change.DropCollectionChange;
import liquibase.ext.mongodb.statement.CreateCollectionStatement;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="createCollection", description="Create collection. Supports all options available: https://docs.mongodb.com/manual/reference/method/db.createCollection/#db.createCollection\nhttps://docs.mongodb.com/manual/reference/command/create/", priority=1, appliesTo={"collection"})
public class CreateCollectionChange
extends AbstractMongoChange {
    private String collectionName;
    private String options;

    public String getConfirmationMessage() {
        return "Collection " + this.getCollectionName() + " created";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new CreateCollectionStatement(this.collectionName, this.options)};
    }

    protected Change[] createInverses() {
        DropCollectionChange inverse = new DropCollectionChange();
        inverse.setCollectionName(this.getCollectionName());
        return new Change[]{inverse};
    }

    public CheckSum generateCheckSum() {
        return super.generateCheckSum(this.collectionName, this.options);
    }

    @Generated
    public CreateCollectionChange() {
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }

    @Generated
    public String getOptions() {
        return this.options;
    }

    @Generated
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @Generated
    public void setOptions(String options) {
        this.options = options;
    }
}

