/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.lockservice;

import com.mongodb.MongoInterruptedException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.lockservice.AdjustChangeLogLockCollectionStatement;
import liquibase.ext.mongodb.lockservice.CreateChangeLogLockCollectionStatement;
import liquibase.ext.mongodb.lockservice.MongoChangeLogLock;
import liquibase.ext.mongodb.lockservice.MongoChangeLogLockToDocumentConverter;
import liquibase.ext.mongodb.lockservice.ReplaceChangeLogLockStatement;
import liquibase.ext.mongodb.lockservice.SelectChangeLogLockStatement;
import liquibase.ext.mongodb.statement.CountCollectionByNameStatement;
import liquibase.ext.mongodb.statement.DropCollectionStatement;
import liquibase.ext.mongodb.statement.FindAllStatement;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.logging.Logger;
import liquibase.nosql.lockservice.AbstractNoSqlLockService;
import liquibase.statement.SqlStatement;
import lombok.Generated;
import org.bson.Document;

public class MongoLockService
extends AbstractNoSqlLockService<MongoLiquibaseDatabase> {
    private final Logger log = Scope.getCurrentScope().getLog(this.getClass());
    private final MongoChangeLogLockToDocumentConverter converter = new MongoChangeLogLockToDocumentConverter();

    public boolean supports(Database database) {
        return "MongoDB".equals(database.getDatabaseProductName());
    }

    @Override
    protected Boolean isLocked() throws DatabaseException {
        Optional<Document> lock = Optional.ofNullable(this.getExecutor().queryForObject((SqlStatement)new SelectChangeLogLockStatement(this.getDatabaseChangeLogLockTableName()), Document.class));
        return lock.map(this.getConverter()::fromDocument).map(MongoChangeLogLock::getLocked).orElse(Boolean.FALSE);
    }

    @Override
    protected int replaceLock(boolean locked) throws DatabaseException {
        try {
            return this.getExecutor().update((SqlStatement)new ReplaceChangeLogLockStatement(this.getDatabaseChangeLogLockTableName(), locked));
        }
        catch (DatabaseException e) {
            if (e.getCause() instanceof MongoInterruptedException && e.getCause().getSuppressed().length > 0 && e.getCause().getSuppressed()[0].getMessage().equals("Interrupted waiting for lock") && Thread.interrupted()) {
                try {
                    this.releaseLock();
                }
                catch (LockException ex) {
                    throw new DatabaseException((Throwable)ex);
                }
                Thread.currentThread().interrupt();
            }
            throw e;
        }
    }

    @Override
    protected List<DatabaseChangeLogLock> queryLocks() throws DatabaseException {
        FindAllStatement findAllStatement = new FindAllStatement(this.getDatabaseChangeLogLockTableName());
        return this.getExecutor().queryForList((SqlStatement)findAllStatement, Document.class).stream().map(Document.class::cast).map(this.getConverter()::fromDocument).filter(MongoChangeLogLock::getLocked).collect(Collectors.toList());
    }

    @Override
    protected Boolean existsRepository() throws DatabaseException {
        try {
            return this.getExecutor().queryForLong((SqlStatement)new CountCollectionByNameStatement(((MongoLiquibaseDatabase)((Object)this.getDatabase())).getDatabaseChangeLogLockTableName())) == 1L;
        }
        catch (DatabaseException e) {
            if ("Could not query for long".equalsIgnoreCase(e.getMessage())) {
                throw new DatabaseException("Failed to create or initialize the lock table", e.getCause());
            }
            throw e;
        }
    }

    @Override
    protected void createRepository() throws DatabaseException {
        CreateChangeLogLockCollectionStatement createChangeLogLockCollectionStatement = new CreateChangeLogLockCollectionStatement(this.getDatabaseChangeLogLockTableName());
        this.getExecutor().execute((SqlStatement)createChangeLogLockCollectionStatement);
    }

    @Override
    protected void adjustRepository() throws DatabaseException {
        if (((MongoLiquibaseDatabase)((Object)this.getDatabase())).getAdjustTrackingTablesOnStartup().booleanValue()) {
            this.getLogger().info("Adjusting database Lock Collection with name: " + ((MongoLiquibaseDatabase)((Object)this.getDatabase())).getConnection().getCatalog() + "." + this.getDatabaseChangeLogLockTableName());
            this.getExecutor().execute((SqlStatement)new AdjustChangeLogLockCollectionStatement(this.getDatabaseChangeLogLockTableName()));
            this.getLogger().info("Adjusted database Lock Collection with name: " + ((MongoLiquibaseDatabase)((Object)this.getDatabase())).getConnection().getCatalog() + "." + this.getDatabaseChangeLogLockTableName());
        } else {
            this.getLogger().info("Skipped Adjusting database Lock Collection with name: " + ((MongoLiquibaseDatabase)((Object)this.getDatabase())).getConnection().getCatalog() + "." + this.getDatabaseChangeLogLockTableName());
        }
    }

    @Override
    protected void dropRepository() throws DatabaseException {
        this.getExecutor().execute((SqlStatement)new DropCollectionStatement(this.getDatabaseChangeLogLockTableName()));
    }

    @Override
    protected Logger getLogger() {
        return this.log;
    }

    @Generated
    public MongoChangeLogLockToDocumentConverter getConverter() {
        return this.converter;
    }
}

