/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.lockservice;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import java.util.Date;
import java.util.Optional;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.lockservice.MongoChangeLogLock;
import liquibase.ext.mongodb.lockservice.MongoChangeLogLockToDocumentConverter;
import liquibase.ext.mongodb.statement.AbstractCollectionStatement;
import liquibase.nosql.statement.NoSqlUpdateStatement;
import lombok.Generated;
import org.bson.Document;

public class ReplaceChangeLogLockStatement
extends AbstractCollectionStatement
implements NoSqlUpdateStatement<MongoLiquibaseDatabase> {
    public static final String COMMAND_NAME = "updateLock";
    private final boolean locked;

    public ReplaceChangeLogLockStatement(String collectionName, boolean locked) {
        super(collectionName);
        this.locked = locked;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCollectionName() + "." + this.getCommandName() + "(" + this.locked + ");";
    }

    @Override
    public int update(MongoLiquibaseDatabase database) {
        MongoChangeLogLock entry = new MongoChangeLogLock(1, new Date(), MongoChangeLogLock.formLockedBy(), this.locked);
        Document inputDocument = new MongoChangeLogLockToDocumentConverter().toDocument(entry);
        inputDocument.put("locked", (Object)this.locked);
        long qtDocuments = database.getMongoDatabase().getCollection(this.collectionName).countDocuments();
        boolean upsert = qtDocuments == 0L;
        Optional<Document> changeLogLock = Optional.ofNullable((Document)database.getMongoDatabase().getCollection(this.collectionName).findOneAndReplace(Filters.eq((String)"_id", (Object)entry.getId()), (Object)inputDocument, new FindOneAndReplaceOptions().upsert(upsert).returnDocument(ReturnDocument.AFTER)));
        return changeLogLock.map(e -> 1).orElse(0);
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }
}

