/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import com.mongodb.client.MongoCollection;
import java.util.Optional;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractCollectionStatement;
import liquibase.nosql.statement.NoSqlExecuteStatement;
import liquibase.nosql.statement.NoSqlUpdateStatement;
import lombok.Generated;
import org.bson.conversions.Bson;

public class DeleteManyStatement
extends AbstractCollectionStatement
implements NoSqlExecuteStatement<MongoLiquibaseDatabase>,
NoSqlUpdateStatement<MongoLiquibaseDatabase> {
    public static final String COMMAND_NAME = "deleteMany";
    private final Bson filter;

    public DeleteManyStatement(String collectionName, Bson filter) {
        super(collectionName);
        this.filter = filter;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCollectionName() + "." + this.getCommandName() + "(" + (String)Optional.ofNullable(this.filter).map(Object::toString).orElse(null) + ");";
    }

    @Override
    public void execute(MongoLiquibaseDatabase database) {
        this.update(database);
    }

    @Override
    public int update(MongoLiquibaseDatabase database) {
        MongoCollection collection = database.getMongoDatabase().getCollection(this.getCollectionName());
        return (int)collection.deleteMany(this.filter).getDeletedCount();
    }

    @Generated
    public Bson getFilter() {
        return this.filter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteManyStatement)) {
            return false;
        }
        DeleteManyStatement other = (DeleteManyStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Bson this$filter = this.getFilter();
        Bson other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeleteManyStatement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Bson $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }
}

