/*
 * Decompiled with CFR 0.152.
 */
package liquibase.nosql.lockservice;

import java.text.DateFormat;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import liquibase.Scope;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.logging.Logger;
import liquibase.nosql.database.AbstractNoSqlDatabase;
import liquibase.nosql.executor.NoSqlExecutor;
import lombok.Generated;

public abstract class AbstractNoSqlLockService<D extends AbstractNoSqlDatabase>
implements LockService {
    private D database;
    private boolean hasChangeLogLock;
    private static final ResourceBundle mongoBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongo");
    private Long changeLogLockPollRate;
    private Long changeLogLockRecheckTime;
    private Boolean hasDatabaseChangeLogLockTable;
    private Boolean adjustedChangeLogLockTable = Boolean.FALSE;
    private Clock clock = Clock.systemDefaultZone();

    public int getPriority() {
        return 10;
    }

    public void setDatabase(Database database) {
        this.database = (AbstractNoSqlDatabase)database;
    }

    public D getDatabase() {
        return this.database;
    }

    public NoSqlExecutor getExecutor() throws DatabaseException {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.getDatabase());
        if (executor instanceof LoggingExecutor) {
            throw new DatabaseException(String.format(mongoBundle.getString("command.unsupported"), "*sql"));
        }
        return (NoSqlExecutor)executor;
    }

    public void init() throws DatabaseException {
        if (!this.hasDatabaseChangeLogLockTable()) {
            this.getLogger().info("Create Database Lock Collection: " + this.getDatabase().getConnection().getCatalog() + "." + this.getDatabaseChangeLogLockTableName());
            this.createRepository();
            this.database.commit();
            this.getLogger().info("Created database lock Collection: " + this.getDatabaseChangeLogLockTableName());
            this.hasDatabaseChangeLogLockTable = true;
        }
        if (!this.adjustedChangeLogLockTable.booleanValue()) {
            this.adjustRepository();
            this.adjustedChangeLogLockTable = Boolean.TRUE;
        }
    }

    public boolean hasChangeLogLock() {
        return this.hasChangeLogLock;
    }

    public void waitForLock() throws LockException {
        boolean locked = false;
        long timeToGiveUp = this.getClock().instant().plusSeconds(this.getChangeLogLockWaitTime() * 60L).toEpochMilli();
        locked = this.acquireLock();
        while (!locked && this.getClock().instant().toEpochMilli() < timeToGiveUp) {
            this.getLogger().info("Waiting for changelog lock....");
            try {
                Thread.sleep(this.getChangeLogLockRecheckTime() * 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            locked = this.acquireLock();
        }
        if (!locked) {
            String lockedBy;
            DatabaseChangeLogLock[] locks = this.listLocks();
            if (locks.length > 0) {
                DatabaseChangeLogLock lock = locks[0];
                lockedBy = lock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(lock.getLockGranted());
            } else {
                lockedBy = "UNKNOWN";
            }
            throw new LockException("Could not acquire change log lock.  Currently locked by " + lockedBy);
        }
    }

    public boolean acquireLock() throws LockException {
        if (this.hasChangeLogLock) {
            return true;
        }
        try {
            this.database.rollback();
            this.init();
            if (this.isLocked().booleanValue()) {
                boolean bl = false;
                return bl;
            }
            this.getLogger().info("Lock Database");
            int rowsUpdated = this.replaceLock(true);
            if (rowsUpdated > 1) {
                throw new LockException("Did not update change log lock correctly");
            }
            if (rowsUpdated == 0) {
                boolean bl = false;
                return bl;
            }
            this.database.commit();
            this.getLogger().info("Successfully Acquired Change Log Lock");
            this.hasChangeLogLock = true;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
        finally {
            try {
                this.database.rollback();
            }
            catch (DatabaseException e) {
                this.getLogger().severe("Error on acquire change log lock Rollback.", (Throwable)e);
            }
        }
    }

    public void releaseLock() throws LockException {
        try {
            if (this.hasDatabaseChangeLogLockTable()) {
                this.getLogger().info("Release Database Lock");
                this.database.rollback();
                int rowsUpdated = this.replaceLock(false);
                if (rowsUpdated != 1) {
                    throw new LockException("Did not update change log lock correctly.\n\n" + rowsUpdated + " rows were updated instead of the expected 1 row  there are more than one rows in the table");
                }
                this.database.commit();
            }
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
        finally {
            try {
                this.hasChangeLogLock = false;
                this.database.setCanCacheLiquibaseTableInfo(false);
                this.getLogger().info("Successfully released change log lock");
                this.database.rollback();
            }
            catch (DatabaseException e) {
                this.getLogger().severe("Error on released change log lock Rollback.", (Throwable)e);
            }
        }
    }

    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            if (!this.hasDatabaseChangeLogLockTable()) {
                return new DatabaseChangeLogLock[0];
            }
            List<DatabaseChangeLogLock> rows = this.queryLocks();
            return (DatabaseChangeLogLock[])rows.stream().map(DatabaseChangeLogLock.class::cast).toArray(DatabaseChangeLogLock[]::new);
        }
        catch (Exception e) {
            throw new LockException((Throwable)e);
        }
    }

    public void forceReleaseLock() throws LockException, DatabaseException {
        this.init();
        this.releaseLock();
    }

    public void reset() {
        this.hasChangeLogLock = false;
        this.hasDatabaseChangeLogLockTable = null;
        this.adjustedChangeLogLockTable = Boolean.FALSE;
    }

    public void destroy() {
        try {
            this.getLogger().info("Dropping Collection Database Change Log Lock: " + this.getDatabaseChangeLogLockTableName());
            this.dropRepository();
            this.getLogger().info("Dropped Collection Database Change Log Lock: " + this.getDatabaseChangeLogLockTableName());
            this.database.commit();
            this.reset();
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    public String getDatabaseChangeLogLockTableName() {
        return this.database.getDatabaseChangeLogLockTableName();
    }

    public Long getChangeLogLockRecheckTime() {
        if (this.changeLogLockRecheckTime != null) {
            return this.changeLogLockRecheckTime;
        }
        return ((GlobalConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class)).getDatabaseChangeLogLockPollRate();
    }

    public void setChangeLogLockRecheckTime(long changeLogLockRecheckTime) {
        this.changeLogLockRecheckTime = changeLogLockRecheckTime;
    }

    public Long getChangeLogLockWaitTime() {
        if (this.changeLogLockPollRate != null) {
            return this.changeLogLockPollRate;
        }
        return ((GlobalConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class)).getDatabaseChangeLogLockWaitTime();
    }

    public void setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.changeLogLockPollRate = changeLogLockWaitTime;
    }

    private boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
        if (Objects.isNull(this.hasDatabaseChangeLogLockTable)) {
            try {
                this.hasDatabaseChangeLogLockTable = this.existsRepository();
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return this.hasDatabaseChangeLogLockTable;
    }

    protected abstract Logger getLogger();

    protected abstract Boolean existsRepository() throws DatabaseException;

    protected abstract void createRepository() throws DatabaseException;

    protected abstract void adjustRepository() throws DatabaseException;

    protected abstract void dropRepository() throws DatabaseException;

    protected abstract Boolean isLocked() throws DatabaseException;

    protected abstract int replaceLock(boolean var1) throws DatabaseException;

    protected abstract List<DatabaseChangeLogLock> queryLocks() throws DatabaseException;

    @Generated
    public Boolean getHasDatabaseChangeLogLockTable() {
        return this.hasDatabaseChangeLogLockTable;
    }

    @Generated
    public Boolean getAdjustedChangeLogLockTable() {
        return this.adjustedChangeLogLockTable;
    }

    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    public void setClock(Clock clock) {
        this.clock = clock;
    }
}

